/* 
 * Copyright (C) 2004 Benoit Poulot-Cazajous
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _POSIX_C_SOURCE 199506L
#define _XOPEN_SOURCE 500
#define _GNU_SOURCE

#include <sys/types.h>
#include <sys/param.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/select.h>
#include <alloca.h>
#include <signal.h>
#include <limits.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <poll.h>
#include <dlfcn.h>

#include "cachecc1.h"

int distcc1(char *name, char *argv[], char *nargv[],
            char *input, char *output, char *compiler)
{
    int i, j;
    char wrappath[PATH_MAX];
    char compname[PATH_MAX];
    char *p;
    int rc;

    strcpy(wrappath, env_distccdir);
    strcat(wrappath, "/distccwrap");
    if (access(wrappath, X_OK)) return 0;
    j = 0;
    nargv[j] = env_distcc;
    if (!nargv[j]) nargv[j] = "/usr/bin/distcc";
    j++;
    nargv[j++] = wrappath;
    nargv[j++] = "-c";
    strcpy(compname, env_distccdir);
    strcat(compname, "/");
    strcat(compname, compiler);
    i = strlen(name);
    p = "unknown";
        /* cc1plus */
    if (name[i-8] == '/') p = &name[i-8];
        /* cc1 */
    if (name[i-4] == '/') p = &name[i-4];
        /* as */
    if (name[i-3] == '/') p = &name[i-3];
    i = strlen(compname);
    strcat(compname, p);
    if (access(compname, F_OK)) {
            /* not found, copy */
        char fntmp[PATH_MAX];
        int f, g;
        compname[i] = 0;
        (void) mkdir(compname, 0777);
        compname[i] = '/';
        sprintf(fntmp, "%s.%ld", compname, (long)getpid());
        f = open(name, O_RDONLY);
        g = open(fntmp, O_RDWR | O_CREAT | O_TRUNC, 0777);
        copy(f, g, fntmp);
        close(g);
        close(f);
        rc = rename(fntmp, compname);
    }
    nargv[j++] = compname;
        /* wrap cc1 args, to hide them from distcc */
    for (i = 1; argv[i]; ++i, ++j) {
        int l;
        nargv[j] = argv[i];
        if (!strcmp(nargv[j], input)) continue;
        if (!strcmp(nargv[j], "-o")) continue;
        if (!strcmp(nargv[j], output)) continue;
        l = strlen(nargv[j]);
        nargv[j] = malloc(l+5);
        strcpy(nargv[j], "-Wd,");
        strcpy(nargv[j]+4, argv[i]);
    }
    nargv[j] = 0;
    return 1;
}

/* arch-tag: 5620bf5a-84b5-4a54-8218-a3ae99a7e5e7 */
