
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <usb.h>
#include <sys/ioctl.h>
#include <string.h>

#include "ctapi_config_l.h"


#ifdef CONFIG_COMPAT
#undef CONFIG_COMPAT
#endif
#ifndef __user
# define __user
#endif
#include <linux/usbdevice_fs.h>

#define MAX_READ_WRITE	4096

#define USB_ERROR_STR(ret, x, args...)	return ret

#ifndef USBDEVFS_CONNECT
# define USBDEVFS_CONNECT _IO('U', 23)
#endif


#define cjusb_log(format, args...) \
  rsct_log(CT_FLAGS_DEBUG_USB, __FILE__, __LINE__, __FUNCTION__, format, ## args)


static int usb_get_fd(usb_dev_handle *uh)
{
	return *((int *)uh);
}

int __usb_bulk_write(usb_dev_handle *dev, int ep, char *bytes, int length,
		     int timeout){
  struct usbdevfs_bulktransfer bulk;
  int ret, sent = 0;

  /* Ensure the endpoint address is correct */
  ep &= ~USB_ENDPOINT_IN;

  do {
    bulk.ep = ep;
    bulk.len = length - sent;
    if (bulk.len > MAX_READ_WRITE)
      bulk.len = MAX_READ_WRITE;
    bulk.timeout = timeout;
    bulk.data = (unsigned char *)bytes + sent;

    ret = ioctl(usb_get_fd(dev), USBDEVFS_BULK, &bulk);
    if (ret < 0) {
      cjusb_log("Error writing to bulk endpoint %d: %d (%s)\n",
		ep, errno, strerror(errno));
      return ret;
    }
    sent += ret;
  } while (ret > 0 && sent < length);

  return sent;
}



int __usb_bulk_read(usb_dev_handle *dev, int ep, char *bytes, int size,
		    int timeout){
#if 1
  struct usbdevfs_bulktransfer bulk;
  int ret, retrieved = 0, requested;

  cjusb_log("Starting to read %d bytes from bulk endpoint\n", size);

  /* Ensure the endpoint address is correct */
  ep |= USB_ENDPOINT_IN;

  while(retrieved<size) {
    bulk.ep = ep;
    requested = size - retrieved;
    if (requested > MAX_READ_WRITE)
      requested = MAX_READ_WRITE;
    bulk.len = requested;
    bulk.timeout = timeout;
    bulk.data = (unsigned char *)bytes + retrieved;

    ret = ioctl(usb_get_fd(dev), USBDEVFS_BULK, &bulk);
    cjusb_log("Result reading from bulk endpoint %02x: %d (%s)\n",
	      ep, errno, strerror(errno));
    if (ret < 0) {
      if (errno==ETIMEDOUT || errno==EINTR) {
	// timeout, retry
      }
      else {
	cjusb_log("Error reading from bulk endpoint %02x: %d (%s)\n",
		  ep, errno, strerror(errno));
	return ret;
      }
    }
    else {
      if (ret!=requested)
	/* eof met */
	break;
      retrieved += ret;
      cjusb_log("Retrieved %d bytes from bulk endpoint %02x (total: %d)\n", ret, ep, retrieved);
    }
  }
  cjusb_log("Finished reading from bulk endpoint: %d bytes\n", retrieved);

  return retrieved;
#endif

#if 0
  struct usbdevfs_bulktransfer bulk;
  int ret, retrieved = 0, requested;

  cjusb_log("Starting to read %d bytes from bulk endpoint\n", size);

  /* Ensure the endpoint address is correct */
  ep |= USB_ENDPOINT_IN;

  do {
    bulk.ep = ep;
    requested = size - retrieved;
    if (requested > MAX_READ_WRITE)
      requested = MAX_READ_WRITE;
    bulk.len = requested;
    bulk.timeout = timeout;
    bulk.data = (unsigned char *)bytes + retrieved;

    ret = ioctl(usb_get_fd(dev), USBDEVFS_BULK, &bulk);
    if (ret < 0) {
      cjusb_log("Error reading from bulk endpoint %02x: %d (%s)\n",
		ep, errno, strerror(errno));

      return ret;
    }
    retrieved += ret;
    cjusb_log("Retrieved %d bytes from bulk endpoint %02x (total: %d)\n", ret, ep, retrieved);
  } while (ret > 0 && retrieved < size && ret == requested);
  cjusb_log("Finished reading from bulk endpoint: %d bytes\n", retrieved);

  return retrieved;
#endif
}



int __usb_reattach_kernel_driver_np(usb_dev_handle *dev, int interface) {
  struct usbdevfs_ioctl command;
  int ret;

  command.ifno = interface;
  command.ioctl_code = USBDEVFS_CONNECT;
  command.data = NULL;

  ret=ioctl(usb_get_fd(dev), USBDEVFS_IOCTL, &command);
  if (ret<0) {
    cjusb_log("IOCTL(USBDEVFS_CONNECT): %d (%s)\n",
	      errno, strerror(errno));
  }
  return ret;
}



