/***************************************************************************
 * CT-API library for the REINER SCT cyberJack pinpad/e-com USB.
 * Copyright (C) 2004  REINER SCT
 * Author: Harald Welte
 * Support: support@reiner-sct.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * File: cjctapi_switch.c
 * CVS: $Id: cjctapi_beep.c 54 2007-03-13 22:16:21Z martin $
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <dlfcn.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/kd.h>
#include <sys/ioctl.h>

#include "ctapi_config_l.h"
#include "cyberjack_l.h"

#define DEBUGP(format, args...) \
  rsct_log(CT_FLAGS_DEBUG_CTAPI, __FILE__, __LINE__, __FUNCTION__, format, ## args)


#ifndef CLOCK_TICK_RATE
#define CLOCK_TICK_RATE 1193180
#endif


struct beep_struct {
  void *xhdl;
  void *display;
  int (*xBell)(void *display, int percent);
  void *(*xOpenDisplay)(char *display_name);
  int (*xCloseDisplay)(void *display);
};





static void beep_console(struct beep_struct *bs){
  int fd;

  DEBUGP("using console\n");
  fd=open("/dev/console", O_WRONLY);
  if (fd!=-1) {
    int arg;
    int rv;

    arg=(150<<16)+440; /* "A" for 150ms */
    rv=ioctl(fd, KDMKTONE, arg);
    close(fd);
    if (!rv)
      return;
    DEBUGP("error %d\n", errno);
  }
  else {
    DEBUGP("error %d\n", errno);
  }
  printf("\a"); /* fallback */
}



static void beep_x11(struct beep_struct *bs){
  DEBUGP("using X11\n");
  bs->xBell(bs->display, 100);
}



void beep_whatever(struct beep_struct *bs){
  DEBUGP("beeping\n");
  if (bs->display)
    beep_x11(bs);
  else
    beep_console(bs);
}



struct beep_struct *beep_init(void){
  struct beep_struct *bs = malloc(sizeof(*bs));
  if (!bs)
    return NULL;

  memset(bs, 0, sizeof(*bs));
  if ((bs->xhdl = dlopen("libX11.so", RTLD_NOW))) {
    bs->xOpenDisplay = dlsym(bs->xhdl, "XOpenDisplay");
    bs->xCloseDisplay = dlsym(bs->xhdl, "XCloseDisplay");
    bs->xBell = dlsym(bs->xhdl, "XBell");
    if (bs->xOpenDisplay && bs->xCloseDisplay && bs->xBell) {
      bs->display = (void *) bs->xOpenDisplay(NULL);
    }
  }
  return bs;
}



void beep_fini(struct beep_struct *bs){
  if (bs->display)
    bs->xCloseDisplay(bs->display);

  if (bs->xhdl)
    dlclose(bs->xhdl);
}



#ifdef BEEP_STANDALONE
int main(int argc, char **argv){
  struct beep_struct *bs;

  bs = beep_init();
  beep_whatever(bs);
  beep_fini(bs);

  exit(0);
}
#endif
