/*
 *  Copyright © 2003 Marco Pesenti Gritti
 *  Copyright © 2003 Christian Persch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: mozilla-sample.cpp 1415 2006-12-23 21:22:06Z jframeau $
 */

#include "mozilla-config.h"
#include "config.h"

#include <glib.h>

#include <nsCOMPtr.h>
#include <nsIDOMEvent.h>
#include <nsIDOMMouseEvent.h>

#include "mozilla-sample.h"

void
mozilla_do_something (gpointer dom_event)
{
	nsCOMPtr<nsIDOMEvent> ev = static_cast<nsIDOMEvent*>(dom_event);
	NS_ENSURE_TRUE (ev,);
	nsCOMPtr<nsIDOMMouseEvent> mev = do_QueryInterface (ev);
	NS_ENSURE_TRUE (mev,);

	nsresult rv;
	PRUint16 button;
	rv = mev->GetButton (&button);
	NS_ENSURE_SUCCESS (rv,);

	g_print ("Button %u\n", button);
	
}
