/* This file contains the SIL OPEN FONT LICENSE translated into as many */
/*  languages as I can find. */

#include <stdio.h>
#include "ofl.h"

static char *ofl_eng[] = {
    "Copyright (c) %1$d, %2$s (<URL|email>),",
    "with Reserved Font Name %3$s.",
    "",
    "This Font Software is licensed under the SIL Open Font License, Version 1.1.",
    "This license is copied below, and is also available with a FAQ at:",
    "http://scripts.sil.org/OFL",
    "",
    "",
    "-----------------------------------------------------------",
    "SIL OPEN FONT LICENSE Version 1.1 - 26 February 2007",
    "-----------------------------------------------------------",
    "",
    "PREAMBLE",
    "The goals of the Open Font License (OFL) are to stimulate worldwide",
    "development of collaborative font projects, to support the font creation",
    "efforts of academic and linguistic communities, and to provide a free and",
    "open framework in which fonts may be shared and improved in partnership",
    "with others.",
    "",
    "The OFL allows the licensed fonts to be used, studied, modified and",
    "redistributed freely as long as they are not sold by themselves. The",
    "fonts, including any derivative works, can be bundled, embedded, ",
    "redistributed and/or sold with any software provided that any reserved",
    "names are not used by derivative works. The fonts and derivatives,",
    "however, cannot be released under any other type of license. The",
    "requirement for fonts to remain under this license does not apply",
    "to any document created using the fonts or their derivatives.",
    "",
    "DEFINITIONS",
    "\"Font Software\" refers to the set of files released by the Copyright",
    "Holder(s) under this license and clearly marked as such. This may",
    "include source files, build scripts and documentation.",
    "",
    "\"Reserved Font Name\" refers to any names specified as such after the",
    "copyright statement(s).",
    "",
    "\"Original Version\" refers to the collection of Font Software components as",
    "distributed by the Copyright Holder(s).",
    "",
    "\"Modified Version\" refers to any derivative made by adding to, deleting,",
    "or substituting -- in part or in whole -- any of the components of the",
    "Original Version, by changing formats or by porting the Font Software to a",
    "new environment.",
    "",
    "\"Author\" refers to any designer, engineer, programmer, technical",
    "writer or other person who contributed to the Font Software.",
    "",
    "PERMISSION & CONDITIONS",
    "Permission is hereby granted, free of charge, to any person obtaining",
    "a copy of the Font Software, to use, study, copy, merge, embed, modify,",
    "redistribute, and sell modified and unmodified copies of the Font",
    "Software, subject to the following conditions:",
    "",
    "1) Neither the Font Software nor any of its individual components,",
    "in Original or Modified Versions, may be sold by itself.",
    "",
    "2) Original or Modified Versions of the Font Software may be bundled,",
    "redistributed and/or sold with any software, provided that each copy",
    "contains the above copyright notice and this license. These can be",
    "included either as stand-alone text files, human-readable headers or",
    "in the appropriate machine-readable metadata fields within text or",
    "binary files as long as those fields can be easily viewed by the user.",
    "",
    "3) No Modified Version of the Font Software may use the Reserved Font",
    "Name(s) unless explicit written permission is granted by the corresponding",
    "Copyright Holder. This restriction only applies to the primary font name as",
    "presented to the users.",
    "",
    "4) The name(s) of the Copyright Holder(s) or the Author(s) of the Font",
    "Software shall not be used to promote, endorse or advertise any",
    "Modified Version, except to acknowledge the contribution(s) of the",
    "Copyright Holder(s) and the Author(s) or with their explicit written",
    "permission.",
    "",
    "5) The Font Software, modified or unmodified, in part or in whole,",
    "must be distributed entirely under this license, and must not be",
    "distributed under any other license. The requirement for fonts to",
    "remain under this license does not apply to any document created",
    "using the Font Software.",
    "",
    "TERMINATION",
    "This license becomes null and void if any of the above conditions are",
    "not met.",
    "",
    "DISCLAIMER",
    "THE FONT SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,",
    "EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF",
    "MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT",
    "OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL THE",
    "COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,",
    "INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL",
    "DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING",
    "FROM, OUT OF THE USE OR INABILITY TO USE THE FONT SOFTWARE OR FROM",
    "OTHER DEALINGS IN THE FONT SOFTWARE.",
    NULL
};

static char *oflurl_eng[] = {
    "http://scripts.sil.org/ofl",
    NULL
};

/* Victor Gaultney said that including these "unofficial" translations of the */
/*  OFL in the 'name' table was a bad idea for legal reasons */
#if 0
static char *ofl_fr[] = {
    "Copyright (c) %1$d, %2$s (<URL|courriel>),",
    "avec le nom réservé suivant %3$s.",
    "",
    "Avertissement légal",
    "",
    "«Cette traduction française de la licence pour les fontes libres de SIL",
    "(SIL Open Font Licence, ou encore OFL) n'est pas une traduction officielle.",
    "Elle n'a pas été publiée par SIL International et n'a pas de valeur légale",
    "pour la distribution des fontes sous OFL: seul le texte anglais original fait",
    "foi.",
    "",
    "Cependant, nous reconnaissons que cette traduction, même sans valeur légale,",
    "peut aider les utilisateurs et les créateurs non anglophones à mieux",
    "comprendre la licence SIL OFL, et faciliter la création et l'utilisation de",
    "polices de caractères selon son modèle de dessin collaboratif.",
    "",
    "Nous encourageons les créateurs qui envisagent de licencier leur",
    "travail sous OFL à lire la FAQ dans leur langue si elle est disponible.",
    "S'il vous plaît, allez sur le site http://scripts.sil.org/FAQ pour lire",
    "la version officielle de cette licence et la FAQ afférante.»",
    "",
    "\"This is an unofficial translation of the SIL Open Font License into",
    "French. It was not published by SIL International, and does not",
    "legally state the distribution terms for fonts that use the OFL.",
    "A release under the OFL is only valid when using the original English",
    "text.",
    "",
    "However, we recognize that this unofficial translation will help users",
    "and designers not familiar with English to understand the SIL OFL better",
    "and make it easier to use and release font families under this",
    "collaborative font design model. We encourage designers who consider",
    "releasing their creation under the OFL to read the FAQ in their own",
    "language if it is available. Please go to http://scripts.sil.org/OFL",
    "for the official version of the license and the accompanying FAQ.\"",
    "",
    "Cette fonte informatique est licenciée sous la licence SIL Open Font Licence, Version 1.1",
    "",
    "Cette licence figure ci dessous, et est aussi disponible,",
    "ainsi qu'une FAQ, à l'adresse: http://scripts.sil.org/OFL",
    "",
    "-----------------------------------------------------------",
    "SIL OPEN FONT LICENCE Version 1.1 - 26 Février 2007",
    "-----------------------------------------------------------",
    "",
    "PRÉAMBULE DU TRADUCTEUR",
    "",
    "l'appellation anglaise OFL a été conservée pour éviter d'introduire",
    "un nouvel acronyme. De même, le mot fonte a été utilisé, comme",
    "synonyme de police de caractère.",
    "",
    "PRÉAMBULE",
    "",
    "Le but de la licence OFL est de stimuler le développement collaboratif",
    "de fontes à travers le monde, d'aider à la création de fontes dans",
    "les communautés académiques ou linguistiques, et de fournir un cadre",
    "libre et ouvert à travers lequel ces fontes peuvent être partagées",
    "et améliorées de manière collective.",
    "",
    "Les fontes sous licence OFL peuvent être utilisées, étudiées, modifiées",
    "et redistribuées librement, tant qu'elles ne sont pas vendues par elles-même.",
    "Les fontes, ainsi que tous leurs dérivés, peuvent être fournies avec,",
    "incorporées, redistribuées et/ou vendues avec des logiciels quelconques,",
    "sous réserve que les appellations réservées ne soient pas utilisées",
    "dans les produits dérivés. La licence des fontes et de leurs produits",
    "dérivés ne peut cependant pas être modifiée. Cette obligation de",
    "conserver la licence OFL pour les fontes et leurs produits dérivés",
    "ne s'applique pas aux documents crées avec.",
    "",
    "DÉFINITIONS",
    "",
    "l'appellation 'fonte informatique' désigne l'ensemble des fichiers mis",
    "à disposition par le(s) titulaire(s) du copyright sous cette licence",
    "et clairement identifiés comme tels. Cela peut inclure des sources,",
    "des scripts de génération, de la documentation.",
    "",
    "l'appellation 'nom de fonte réservé' désigne n'importe quel nom",
    "désigné comme tel dans le copyright.",
    "",
    "'Version originale' désigne une 'fonte informatique' telle que",
    "distribuée par le(s) titulaire(s) du copyright.",
    "",
    "'Version modifiée' désigne tout travail dérivé obtenu en ajoutant,",
    "supprimant ou remplaçant tout ou partie de n'importe quel élément",
    "de la 'version originale', en changeant de format ou en portant",
    "la 'fonte informatique' vers un nouvel environnement.",
    "",
    "'l'Auteur' désigne un créateur, ingénieur, programmeur, auteur",
    "technique ou tout autre personne ayant contribué à la 'fonte",
    "informatique'.",
    "",
    "PERMISSIONS ET CONDITIONS",
    "",
    "La permission est ici accordée, sans contrepartie, à toute personne",
    "ayant obtenu une copie de la 'fonte informatique' de l'utiliser,",
    "l'étudier, la copier, la fusionner, l'inclure, la modifier, la",
    "redistribuer et la vendre, modifiée ou non, aux conditions suivantes:",
    "",
    "1) La 'fonte informatique', en tout ou partie, en version originale",
    "ou modifiée, ne peut être vendue par elle même.",
    "",
    "2) Les versions originales ou modifiées de la 'fonte informatique'",
    "peuvent être liées, redistribuées et/ou vendues avec n'importe quel",
    "logiciel, à condition que chaque copie contienne la déclaration de",
    "copyright ci-dessus ainsi que cette licence. Ces pièces peuvent",
    "être soit des fichiers textes autonomes, des entêtes de fichiers",
    "accessibles à un lecteur humain, ou figurer dans des méta-données",
    "accessibles par programme, dans des fichiers textes ou binaires,",
    "tant que leur texte est facilement accessible à un utilisateur.",
    "",
    "3) Aucune version modifiée de la 'fonte informatique' ne peut",
    "utiliser les noms réservés sans autorisation écrite expresse",
    "du propriétaire du copyright. Cette restriction ne s'applique",
    "qu'au nom principal de la police tel que présenté à l'utilisateur.",
    "",
    "4) le ou les noms du titulaire du copyright et ceux du ou des",
    "auteurs ne peuvent pas être utilisés pour promouvoir, conseiller",
    "ou faire de la publicité pour des versions modifiées, sauf pour",
    "rappeler leur(s) contribution(s), ou alors avec leur autorisation",
    "écrite expresse.",
    "",
    "5) La 'fonte informatique', modifiée ou non, en tout ou partie,",
    "doit être distribuée avec exactement cette même licence. Cette",
    "obligation de conserver la licence ne s'applique pas aux documents",
    "crées en utilisant la 'fonte informatique'.",
    "",
    "FIN DE CONTRAT",
    "",
    "Cette licence devient nulle et sans objet si l'une quelconque",
    "des conditions ci dessus n'est pas remplie.",
    "",
    "CLAUSE DE NON RESPONSABILITÉ",
    "",
    "LA FONTE INFORMATIQUE EST FOURNIE TELLE QUELLE, SANS GARANTIE",
    "D'AUCUNE SORTE, NI IMPLICITE NI EXPLICITE, Y COMPRIS ET DE",
    "MANIÈRE NON LIMITATIVE SANS GARANTIE DE COMMERCIABILITÉ, DE",
    "CONFORMITÉ À UNE UTILISATION PARTICULIÈRE, DE RESPECT DES",
    "COPYRIGHTS, BREVETS, MARQUES COMMERCIALES OU AUTRES DROITS.",
    "",
    "EN AUCUN CAS LE TITULAIRE DU COPYRIGHT NE POURRA ÊTRE TENU",
    "POUR RESPONSABLE EN CAS DE RÉCLAMATION, DOMMAGE OU AUTRE",
    "CONSÉQUENCE, Y COMPRIS AUCUN DOMMAGE GÉNÉRAL, SPÉCIFIQUE,",
    "INDIRECT, INCIDENT OU RÉSULTANT, QUE CE SOIT CONTRACTUELLEMENT,",
    "À TITRE DE DÉDOMMAGEMENT OU AUTREMENT, SURVENANT SUITE À",
    "L'USAGE OU L'IMPOSSIBILITÉ D'USAGE DE LA FONTE INFORMATIQUE,",
    "OU TOUTE AUTRE AFFAIRE IMPLIQUANT LA FONTE INFORMATIQUE.",
    "",
    NULL
};

static char *ofl_el[] = {
    "Copyright (c) %1$d, %2$s (<URL|email>),",
    "with Reserved Font Name %3$s.",
    "",
    "«Αυτή είναι μια μη-πιστοποιημένη μετάφραση της άδειας ανοικτών",
    "γραμματοσειρών (ή απλά ΑΑΓ) της SIL στα ελληνικά. Δεν έχει δημοσιευθεί",
    "από την SIL International και επιπλέον δεν αποτελεί νομικό έγγραφο,",
    "που να καθορίζει τους όρους διανομής γραμματοσειρών που χρησιμοποιούν",
    "την ΑΑΓ. Η έκδοση μιας γραμματοσειράς υπό την ΑΑΓ ισχύει μόνο, αν",
    "χρησιμοποιεί το πρωτότυπο αγγλικό κείμενο.",
    "",
    "Πάντως αναγνωρίζουμε ότι αυτή η μη-πιστοποιημένη μετάφραση, θα βοηθήσει",
    "τους χρήστες και τους σχεδιαστές, που δεν γνωρίζουν αγγλικά να",
    "κατανοήσουν καλύτερα την ΑΑΓ της SIL, ώστε να καταστεί ευκολότερη η",
    "χρήση και η έκδοση οικογενειών γραμματοσειρών, σύμφωνα με τούτο το",
    "συνεργατικό μοντέλο σχεδιασμού γραμματοσειρών. Ενθαρρύνουμε σχεδιαστές,",
    "που σκέφτονται να εκδόσουν τα δημιουργήματά τους σύμφωνα με την ΑΑΓ, να",
    "διαβάσουν το κείμενο των Συχνά Τιθόμενων Ερωτήσεων (ΣΤΕ) στην γλώσσα",
    "τους, αν αυτό είναι διαθέσιμο. Παρακαλούμε ανοίξτε την σελίδα",
    "http://scripts.sil.org/OFL, για να διαβάσετε την επίσημη έκδοση της",
    "αδείας και το σχετικό κείμενο των ΣΤΕ.»",
    "",
    "\"This is an unofficial translation of the SIL Open Font License into",
    "Greek. It was not published by SIL International, and does not",
    "legally state the distribution terms for fonts that use the OFL.",
    "A release under the OFL is only valid when using the original English",
    "text.",
    "",
    "However, we recognize that this unofficial translation will help users",
    "and designers not familiar with English to understand the SIL OFL better",
    "and make it easier to use and release font families under this",
    "collaborative font design model. We encourage designers who consider",
    "releasing their creation under the OFL to read the FAQ in their own",
    "language if it is available. Please go to http://scripts.sil.org/OFL",
    "for the official version of the license and the accompanying FAQ.\"",
    "",
    "Αυτό το λογισμικό γραμματοσειράς υπόκειται στην Άδεια Ανοικτών Γραμματοσειρών",
    "της SIL, έκδοση 1.1. Η άδεια παρουσιάζεται παρακάτω και είναι",
    "διαθέσιμη, μαζί με σχετικές απαντήσεις σε συχνές απορίες, από τον δικτυκό τόπο:",
    "http://scripts.sil.org/OFL",
    "",
    "--------------------------------------------------------------------------------",
    "Άδεια Ανοικτών Γραμματοσειρών της SIL έκδοση 1.1. - 26 Φεβρουαρίου 2007",
    "--------------------------------------------------------------------------------",
    "",
    "ΠΡΟΛΟΓΟΣ",
    "Στόχος της Άδειας Ανοικτών Γραμματοσειρών (ΑΑΓ) είναι να παρακινήσει την",
    "παγκόσμια ανάπτυξη συνεργασιών (cooperative projects) που αφορούν γραμματοσειρές,",
    "να υποστηρίξει τις προσπάθειες δημιουργίας γραμματοσειρών τόσο από την ακαδημαϊκή",
    "κοινότητα όσο και από την κοινότητα των γλωσσολόγων, και, τέλος, να παράσχει ένα ελεύθερο ",
    "και ανοικτό πλαίσιο εργασίας στο οποίο οι γραμματοσειρές θα μπορούν να μοιράζονται",
    "αλλά και να βελτιώνονται σε συνεργασία με άλλους.",
    " ",
    "Η ΑΑΓ επιτρέπει σε γραμματοσειρές που έχουν εκδοθεί με την άδεια αυτή να χρησιμοποιούνται, ",
    "μελετούνται, τροποποιούνται και να επαναδιανέμονται ελεύθερα εφόσον αυτές δεν πωλούνται.",
    "Οι γραμματοσειρές καθώς και τα παράγωγα αυτής, μπορούν να συνοδεύουν, να ενσωματώνονται, ",
    "να επαναδιανέμονται ή/και να πωλούνται μαζί με οποιοδήποτε άλλο λογισμικό υπό τον όρο ότι ",
    "κανένα πρωτότυπο όνομα δεν χρησιμοποιείται από οποιοδήποτε παράγωγο λογισμικό. Τόσο οι γραμματοσειρές",
    "όσο και τα παράγωγά τους, δεν μπορούν να εκδοθούν υπό κάποιο αλλο τύπο αδείας. Η απαίτηση οι ",
    "γραμματοσειρές να παραμένουν υπό αυτή την άδεια δεν ισχύει για έγγραφα που δημιουργούνται ",
    "χρησιμοποιώντας τις γραμματοσειρές ή παράγωγά τους.",
    "",
    "ΟΡΙΣΜΟΙ",
    "",
    "Ο όρος «λογισμικό γραμματοσειράς» αναφέρεται στο σύνολο των αρχείων που γίνονται διαθέσιμα",
    "από τον κάτοχο των πνευματικών δικαιωμάτων υπό την άδεια ΑΑΓ και τα οποία πρέπει",
    "να σημειώνονται ως τέτοια. Το σύνολο αρχείων μπορεί να συμπεριλαμβάνει πηγαίο κώδικα,  ",
    "κώδικα που χρησιμοποιείται άμεσα για την κατασκευή λογισμικού, καθώς και τεκμηρίωση. ",
    "",
    "Ο όρος «κατοχυρωμένο όνομα γραμματοσειράς» αναφέρεται σε οποιοδήποτε όνομα γραμματοσειράς ",
    "το οποίο σημειώνεται ως τέτοιο με ειδική δήλωση πνευματικών δικαιωμάτων.",
    "",
    "Ο όρος «αρχική έκδοση» αναφέρεται σε μία συλλογή στοιχείων λογισμικού γραμματοσειράς",
    "όπως αυτά διανέμονται από τους κατόχους των πνευματικών δικαιωμάτων.",
    "",
    "Ο όρος «τροποποιημένη έκδοση» αναφέρεται σε οποιοδήποτε παράγωγο το οποίο",
    "έγινε με την προσθήκη, τη διαγραφή, τη μερική ή καθ' ολοκληρία αλλαγή",
    "οποιοδήποτε στοιχείου της αρχικής έκδοσης, αλλάζοντας τη μορφή των αρχείων ή",
    "μεταφέροντας το λογισμικό γραμματοσειράς σε νέο υπολογιστικό περιβάλλον.",
    "",
    "Ο όρος «δημιουργός» αναφέρεται σε οποιοδήποτε σχεδιαστή, μηχανικό, προγραμματιστή,",
    "συγγραφέα τεχνικών κειμένων ή άλλο πρόσωπο το οποίο συνεισφέρει στο λογισμικό ",
    "γραμματοσειράς.",
    "",
    "ΔΙΚΑΙΩΜΑΤΑ & ΣΥΝΘΗΚΕΣ",
    "",
    "Με την παρούσα άδεια, δίνεται το δικαίωμα, χωρίς καμία οικονομική χρέωση, σε κάθε",
    "πρόσωπο που έχει αποκτήσει αντίγραφο του λογισμικού γραμματοσειράς, να το χρησιμοποιήσει,",
    "μελετήσει, αντιγράψει, συγχωνεύσει, ενσωματώσει, τροποποιήσει, αναδιανείμει ή",
    "πωλήσει τροποποιημένα ή μη-τροποποιημένα αντίγραφα του λογισμικού γραμματοσειρών",
    "υπό τους παρακάτω όρους: ",
    "",
    "1) Ούτε το λογισμικό γραμματοσειράς αλλά ούτε και κάθε ένα από τα ξεχωριστά στοιχεία ",
    "που απαρτίζουν το λογισμικό γραμματοσειράς στην αρχική ή σε τροποποιημένη έκδοση, ",
    "μπορούν να πωληθούν ως έχουν.",
    "",
    "2) Η αρχική ή μία τροποποιημένη έκδοση του λογισμικού γραμματοσειράς μπορούν να αποτελούν τμήμα λογισμικού πακέτου, να αναδιανεμηθούν ή/και να πωληθούν με κάποιο λογισμικό,",
    "εφόσον κάθε αντίγραφο περιέχει δήλωση πνευματικών δικαιωμάτων",
    "και την ΑΑΓ. Η άδεια και η δήλωση  μπορούν να συμπεριληφθούν είτε ως ξεχωριστά ",
    "αρχεία κειμένου, είτε ως αναγνώσιμες κεφαλίδες, σε κατάλληλα πεδία μετα-δεδομένων που ",
    "είναι αναγνώσιμα από κάποιο πρόγραμμα και αποτελούν τμήμα κάποιου αρχείων, κειμένου ή ",
    "δυαδικών, εφόσον αυτά τα πεδία μπορούν να θεαθούν από τον χρήστη.",
    "",
    "3) Καμία τροποποιημένη έκδοση του λογισμικού γραμματοσειρών δεν μπορεί να χρησιμοποιεί το",
    "κατοχυρωμένο όνομα γραμματοσειράς εκτός και αν αυτό το επιτρέψει ο κάτοχος των",
    "πνευματικών δικαιωμάτων του λογισμικού γραμματοσειρών με γραπτή κατηγορηματική άδεια. ",
    "Ο περιορισμός αυτός αφορά το κύριο όνομα γραμματοσειράς, όπως αυτό έχει παρουσιαστεί σε τρίτους.",
    "",
    "4) Τα ονομάτα των κατόχων των πνευματικών δικαιωμάτων ή των δημιουργών του λογισμικού ",
    "γραμματοσειράς δεν θα πρέπει να χρησιμοποιούνται για την προώθηση, προβολή ή διαφήμιση",
    "οποιασδήποτε τροποποιημένης έκδοσης, εκτός και αν πρόκειται να αναγνωρισθεί η προσφορά του ",
    "κατόχου των πνευματικών δικαιωμάτων και του δημιουργού, ή εάν υπάρχει γραπτή συνένεση.",
    "",
    "5) Το λογισμικό γραμματοσειράς, τροποποιημένο ή μη-τροποποιημένο, εν μέρει ή εξ ολοκλήρου, ",
    "πρέπει να διανέμεται καθ' ολοκληρία υπό αυτή την άδεια, ενώ δεν πρέπει να διανέμεται υπό ",
    "καμία άλλη άδεια. Η απαίτηση οι γραμματοσειρές να παραμένουν υπό αυτή την άδεια ισχύει για",
    "οποιοδήποτε έγγραφο το οποίο δημιουργήθηκε χρησιμοποιώντας το εν λόγω λογισμικό γραμματοσειράς. ",
    "",
    "ΑΚΥΡΩΣΗ",
    "",
    "Η παρούσα άδεια καθίσταται άκυρη εάν παραβιαστεί οποιασδήποτε από τους παραπάνω όρους.",
    "",
    "",
    "ΑΠΟΠΟΙΗΣΗ ΕΥΘΥΝΩΝ",
    "",
    "ΤΟ ΛΟΓΙΣΜΙΚΟ ΓΡΑΜΜΑΤΟΣΕΙΡΑΣ ΠΑΡΕΧΕΤΑΙ «ΩΣ ΕΧΕΙ», ΧΩΡΙΣ ΚΑΜΙΑ ΕΓΓΥΗΣΗ ΟΠΟΙΑΣΔΗΠΟΤΕ ΜΟΡΦΗΣ, ΡΗΤΗΣ",
    "Ή ΥΠΟΔΗΛΟΥΜΕΝΗΣ, ΣΥΜΠΕΡΙΛΑΜΒΑΝΟΜΕΝΩΝ, ΧΩΡΙΣ ΠΕΡΙΟΡΙΣΜΟ, ΕΓΓΥΗΣΕΩΝ ΕΜΠΟΡΕΥΣΙΜΟΤΗΤΑΣ, ΚΑΤΑΛΛΗΛΟΤΗΤΑΣ",
    "ΓΙΑ ΕΝΑ ΣΥΓΚΕΚΡΙΜΕΝΟ ΣΚΟΠΟ ΚΑΙ ΜΗ-ΠΑΡΑΒΑΣΗΣ ΠΝΕΥΜΑΤΙΚΩN ΔΙΚΑΙΩΜΑΤΩΝ, ΔΙΠΛΩΜΑΤΩΝ ΕΥΡΕΣΙΤΕΧΝΙΑΣ, ",
    "ΕΜΠΟΡΙΚΩΝ ΣΗΜΑΤΩΝ Ή ΑΛΛΩΝ ΔΙΚΑΙΩΜΑΤΩΝ. ΣΕ ΚΑΜΙΑ ΠΕΡΙΠΤΩΣΗ, Ο ΚΑΤΟΧΟΣ ΤΩΝ ΠΝΕΥΜΑΤΙΚΩΝ ΔΙΚΑΙΩΜΑΤΩΝ",
    "ΔΕΝ ΕΙΝΑΙ ΥΠΕΥΘΥΝΟΣ ΚΑΤΑ ΤΟΝ ΝΟΜΟ ΓΙΑ ΟΠΟΙΑΔΗΠΟΤΕ ΑΞΙΩΣΗ Ή ΑΛΛΗ ΥΠΟΧΡΕΩΣΗ ΠΡΟΚΥΨΕΙ ΑΠΟ",
    "ΟΠΙΑΔΗΠΟΤΕ ΓΕΝΙΚΗ, ΕΙΔΙΚΗ, ΕΜΜΕΣΗ, ΣΥΜΠΤΩΜΑΤΙΚΗ Ή ΕΠΑΚΟΛΟΥΘΗ ΖΗΜΙΑ, ΕΑΝ ΓΙΝΕΙ ΣΕ ΔΡΑΣΗ ΣΥΜΒΑΣΗΣ,",
    "ΑΔΙΚΟΠΡΑΞΙΑ Ή ΟΤΙΔΗΠΟΤΕ ΑΛΛΟ, ΕΝΩ ΠΡΟΕΡΧΕΤΑΙ ΑΠΟ ΤΟΝ ΧΡΗΣΗ Ή ΤΗΝ ΑΝΙΚΑΝΟΤΗΤΑ ΧΡΗΣΗΣ ΤΟΥ ΛΟΓΙΣΜΙΚΟΥ",
    "ΓΡΑΜΜΑΤΟΣΕΙΡΑΣ, Ή ΕΝ ΓΕΝΕΙ ΑΠΟ ΑΛΛΕΣ ΠΡΑΞΕΙΣ ΣΤΟ ΛΟΓΙΣΜΙΚΟ ΓΡΑΜΜΑΤΟΣΕΙΡΑΣ.",
    NULL
};
#endif

struct str_lang_data ofl_str_lang_data[] = {
    { ttf_license, 0x409, ofl_eng },
    { ttf_licenseurl, 0x409, oflurl_eng },
#if 0
    { ttf_license, 0x40c, ofl_fr },
    { ttf_license, 0x408, ofl_el },
#endif
    { 0, 0, NULL }
};
