;; R4600 and R4650 pipeline description.
;;   Copyright (C) 2004, 2005 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the
;; Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
;; MA 02110-1301, USA.


;; This file overrides parts of generic.md.  It is derived from the
;; old define_function_unit description.
;;
;; We handle the R4600 and R4650 in much the same way.  The only difference
;; is in the integer multiplication and division costs.

(define_insn_reservation "r4600_imul" 10
  (and (eq_attr "cpu" "r4600")
       (eq_attr "type" "imul,imul3,imadd"))
  "imuldiv*10")

(define_insn_reservation "r4600_idiv" 42
  (and (eq_attr "cpu" "r4600")
       (eq_attr "type" "idiv"))
  "imuldiv*42")


(define_insn_reservation "r4650_imul" 4
  (and (eq_attr "cpu" "r4650")
       (eq_attr "type" "imul,imul3,imadd"))
  "imuldiv*4")

(define_insn_reservation "r4650_idiv" 36
  (and (eq_attr "cpu" "r4650")
       (eq_attr "type" "idiv"))
  "imuldiv*36")


(define_insn_reservation "r4600_load" 2
  (and (eq_attr "cpu" "r4600,r4650")
       (eq_attr "type" "load,fpload,fpidxload"))
  "alu")

(define_insn_reservation "r4600_fmove" 1
  (and (eq_attr "cpu" "r4600,r4650")
       (eq_attr "type" "fabs,fneg,fmove"))
  "alu")

(define_insn_reservation "r4600_fmul_single" 8
  (and (eq_attr "cpu" "r4600,r4650")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r4600_fdiv_single" 32
  (and (eq_attr "cpu" "r4600,r4650")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r4600_fdiv_double" 61
  (and (eq_attr "cpu" "r4600,r4650")
       (and (eq_attr "type" "fdiv,frdiv")
	    (eq_attr "mode" "DF")))
  "alu")

(define_insn_reservation "r4600_fsqrt_single" 31
  (and (eq_attr "cpu" "r4600,r4650")
       (and (eq_attr "type" "fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "alu")

(define_insn_reservation "r4600_fsqrt_double" 60
  (and (eq_attr "cpu" "r4600,r4650")
       (and (eq_attr "type" "fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "alu")
