#ifndef GRAPHICS_H
#define GRAPHICS_H

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "main.h"

// ----

GtkWidget* drawing_area;

gint drawing_area_width;
gint drawing_area_height;

GdkPixmap* pixmap;	/* Backing pixmap for drawing area */

GdkPixbuf* title_screen_original;	/* The loaded image for the title screen */
GdkPixbuf* title_screen_scaled;		/* The title image scaled to window size */

GdkPixbuf* hiscore_screen_original;
GdkPixbuf* hiscore_screen_scaled;

GdkPixbuf* instructions_screen_original;
GdkPixbuf* instructions_screen_scaled;

GdkPixbuf* ingame_background_original;
GdkPixbuf* ingame_background_scaled;

GdkPixbuf* ingame_foreground_original;
GdkPixbuf* ingame_foreground_scaled;

GdkPixbuf* ship_original;
GdkPixbuf* ship_scaled;

GdkPixbuf* dead_ship_original;
GdkPixbuf* dead_ship_scaled;

GdkPixbuf* bullet_original;
GdkPixbuf* bullet_scaled;

gint graphics_level;		/* What graphics we are showing for this level. */

// ----

gboolean
graphics_canvas_configure 		       (GtkWidget         *widget,
                                        GdkEventConfigure *event,
                                        gpointer           user_data);

gboolean
graphics_canvas_expose	               (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data);

/* Image handling */
void graphics_setup();
void graphics_setup_level();
void graphics_scale_images();

void graphics_quit();

/* Draw everything from scratch */
void graphics_redraw_whole_screen();

/* Ship drawing */
void graphics_redraw_ship();

/* Bullet drawing */
void graphics_redraw_bullet();

/* Building drawing */
void graphics_redraw_building( const gint building_no, const gint old_height );

/* ------------------------------------------------- */

void _unref_nonlevel_original_images();
void _unref_nonlevel_scaled_images();

void _unref_level_original_images();
void _unref_level_scaled_images();

void _load_level_original_images();
void _load_nonlevel_original_images();

void _scale_level_images();
void _scale_nonlevel_images();

void _ingame_redraw_whole_screen();
void _died_redraw_whole_screen();
void _level_complete_redraw_whole_screen();
void _title_screen_redraw_whole_screen();
void _hiscore_screen_redraw_whole_screen();
void _instructions_screen_redraw_whole_screen();

void _draw_ship();
void _draw_dead_ship();
void _remove_ship_at( const gint pos_x, const gint pos_y );
void _queue_draw_ship();
void _queue_draw_ship_at( const gint pos_x, const gint pos_y );
GdkRectangle _ship_shape( const gint pos_x, const gint pos_y );

void _draw_bullet();
void _remove_bullet_at( const gint pos_x, const gint pos_y );
void _queue_draw_bullet();
void _queue_draw_bullet_at( const gint pos_x, const gint pos_y );
GdkRectangle _bullet_shape( const gint pos_x, const gint pos_y );

void _draw_building( const gint building_no );

/* Scaling block to pixel */
gint _scaleup_pos_x( const gdouble block_val );
gint _scaleup_pos_y( const gdouble block_val );
gint _scaleup_size_x( const gdouble block_val );
gint _scaleup_size_y( const gdouble block_val );

/* Text drawing */
void _draw_string( double x, double y, double height, gchar* text );

#endif


