/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanpreviewarea.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanpreviewarea
 * @short_description: A scan area selector
 *
 * This widget is primarily intended to be reused by #GnomeScanPreview
 * and #GnomeScanAdvancedPreview. #GnomeScanPreviewArea shows a
 * #GtkScrolledWindow containing a scan preview. The preview image has
 * a selectable rectangle the user can move an resize. When the user
 * resize the area, the widget sent to the connected context the
 * selected area. #GnomeScanPreviewArea is connected to the
 * #GnomeScanContext::"preview-received" signal in order to update the
 * preview. However, #GnomeScanPreviewArea does not ask for a preview,
 * so application should use #GnomeScanPreview and
 * #GnomeScanAdvancedPreview which have a "Refresh" button, unless the
 * application implements its own preview widget.
 */
#ifndef GNOME_SCAN_PREVIEW_AREA_H
#define GNOME_SCAN_PREVIEW_AREA_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

#define	GNOME_TYPE_SCAN_PREVIEW_AREA		(gnome_scan_preview_area_get_type ())
#define GNOME_SCAN_PREVIEW_AREA(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PREVIEW_AREA, GnomeScanPreviewArea))
#define GNOME_SCAN_PREVIEW_AREA_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PREVIEW_AREA, GnomeScanPreviewAreaClass))
#define GNOME_IS_SCAN_PREVIEW_AREA(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PREVIEW_AREA))
#define GNOME_IS_SCAN_PREVIEW_AREA_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PREVIEW_AREA))
#define GNOME_SCAN_PREVIEW_AREA_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PREVIEW_AREA, GnomeScanPreviewAreaClass))

typedef struct _GnomeScanPreviewArea			GnomeScanPreviewArea;
typedef struct _GnomeScanPreviewAreaClass		GnomeScanPreviewAreaClass;

struct _GnomeScanPreviewArea {
  GtkScrolledWindow		parent;

  /*< public >*/
  GnomeScanContext	*context;
  GtkWidget		*drawing_area;
  /* Current preview resolution */
  gdouble		resolution;
};

struct _GnomeScanPreviewAreaClass {
  GtkScrolledWindowClass	parent;

  /* SIGNALS */

  /* CALLBACKS */
  void	(*rotate_clockwise_clicked)		(GnomeScanPreviewArea *pa,
						 gpointer data);

  void	(*rotate_counter_clockwise_clicked)	(GnomeScanPreviewArea *pa,
						 gpointer data);
};

enum {
  GNOME_SCAN_PREVIEW_AREA_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_preview_area_get_type			(void);

/* Methods */

GtkWidget*		gnome_scan_preview_area_new 				(GnomeScanContext *context);

void			gnome_scan_preview_area_refresh				(GnomeScanPreviewArea *area);

GtkWidget*		gnome_scan_preview_area_button_refresh			(GnomeScanPreviewArea *area);

GtkWidget*		gnome_scan_preview_area_button_rotate_cw		(GnomeScanPreviewArea *area);

GtkWidget*		gnome_scan_preview_area_button_rotate_ccw		(GnomeScanPreviewArea *area);

/* Properties */

#endif
