#define MAIN
#include "glob.h"
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "function.h"
#include "mapcalc.h"

int 
main (int argc, char *argv[])
{
    char buf[400];
    char result[100];
    int ok;
    int allok = 0;
    int interactive;
    int i;
    char *tempfile;
    FILE *exp_fd;

    G_gisinit (argv[0]);

    G_get_window (&current_region);

    tempfile = G_tempfile();

    max_rows_in_memory = 3;
    if (argc > 1 && sscanf (argv[1], "-n%d", &max_rows_in_memory) == 1)
    {
	argv++;
	argc--;
    }

       if ( argc > 1 && ( (strcmp(argv[1], "help") == 0) ||
                          (strcmp(argv[1], "-help") == 0) ||
                          (strcmp(argv[1], "-h") == 0) ) ) {
	fprintf(stderr, "r.mapcalc - Raster map layer data calculator\n\n");
	fprintf(stderr, "r.mapcalc performs arithmetic on raster map layers.\n");
	fprintf(stderr, "New raster map layers can be created which are arithmetic expressions involving existing raster map layers, integer or floating point constants, and functions.\n\n");
	fprintf(stderr, "For more information use g.manual r.mapcalc\n");
	exit(1);
	}

    if (argc >= 2)
    {
	exp_fd = fopen (tempfile, "w");
	if (exp_fd == NULL)
	    G_fatal_error ("can't open any temp files\n");
	fprintf (exp_fd, "%s", argv[1]);
	for (i = 2; i < argc; i++)
	    fprintf (exp_fd, " %s", argv[i]);
	fprintf (exp_fd, "\n");
	fclose (exp_fd);
	interactive = 0;
    }
    else
	interactive = isatty(0);

/* come up with a very large integer */
    HUGE = 0;
    i = sizeof(int) * 8 - 1;
    while (i-- > 0)
	HUGE += (1 << i);

/* initialize the allocated stacks as unallocated */
    expression_stack_nalloc = 0;
    expression_stack        = NULL;
    execute_stack_nalloc    = 0;
    execute_stack           = NULL;

    while (1)
    {
	if ((argc < 2) && (!input(tempfile))) break;
	expression_stack_depth = 0;
	execute_stack_depth = 0;
	execute_stack_depth_max = 0;

#ifdef DEBUG
sprintf (buf, "cat -n %s | fmt", tempfile);
system (buf);
#endif
	exp_fd = fopen (tempfile, "r");
	if (exp_fd == NULL)
	    G_fatal_error ("can't open temp files\n");
	if (fscanf (exp_fd, "%40s", buf) != 1)
	    break;
	if (strcmp (buf, "exit") == 0)
	    break;
	if (strcmp (buf, "list") == 0)
	{
	    if (fscanf (exp_fd, "%40s", buf) != 1)
		G_list_element ("cell", "cell", "", (int(*)())0);
	    else
		G_list_element ("cell", "cell", buf, (int(*)())0);
	    fclose(exp_fd);
	    continue;
	}
	fseek (exp_fd, 0L, 0);
	if (polish (exp_fd, result))
	{
	    fclose (exp_fd);
	    if (interactive && G_find_file ("cell",result,G_mapset()))
	    {
	       sprintf (buf, "%s - already exists. ok to overwrite? ",result);
	       if (!G_yes(buf,-1)) continue;
	    }

	    floating_point_exception_occurred = 0;
	    overflow_occurred = 0;
#ifdef SIGFPE
	    signal (SIGFPE, fpe);
#endif
	    fprintf (stderr, "\nEXECUTING %s = ... ", result); fflush(stdout);
	    ok = execute (result);
	    if ( !ok ) {
		allok = ok;
	    }
	    
#ifdef SIGFPE
	    signal (SIGFPE, SIG_DFL);
#endif
	    if(ok)
	    {
		fprintf (stderr, "CREATING SUPPORT FILES FOR %s\n",result);
		if (floating_point_exception_occurred) {
		    fprintf (stderr, "NOTE: floating point error(s) occured in the calculation\n");
		    allok = 1;
		}
		if (overflow_occurred) {
		    fprintf (stderr, "NOTE: overflow occured in the calculation\n");
		    allok = 1;
		}
		if (integer_division_occurred)
		    fprintf (stderr, "NOTE: integer division occured in the calculation; precision lost\n");
		create_support_files (result, tempfile);
		print_range (result);
	    }
	    free_execute_stack();

	    /* cp the cats file when appropriate 11/2001 Huidae Cho */
	    if(!allok && cp_cats){
		    char *mapset;

		    if((mapset=strchr(catmap, '@'))){
		        *mapset = 0;
			mapset++;
		    }else
		    if(G_find_file("cats", catmap, G_mapset()))
			mapset = G_mapset();
		    else
			mapset = "PERMANENT";

		    if(G_find_file("cats", catmap, mapset)){
		    	fprintf(stdout, "Copying category labels from <%s@%s> to <%s@%s>\n", catmap, mapset, result, G_mapset());
		    	sprintf(buf, "/bin/cp %s/%s/cats/%s %s/%s/cats/%s", G_location_path(), mapset, catmap, G_location_path(), G_mapset(), result);
		    	system(buf);
		    }else
			fprintf(stderr, "NOTE: cannot copy category labels for <%s@%s>\n      as not present in <%s@%s>\n", result, G_mapset(), catmap, mapset);
	    }
        } else {
	  allok = 1; /* added 11/00 Andreas Lange */
	}
	free_expression_stack();
	if (argc >= 2) break;
    }
    exit(allok); /* fixed 11/99 Luca Palmeri */
}
