/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "anthyprediction.h"

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif


#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif


AnthyPrediction::AnthyPrediction(ConfigPointer cfg,AnthyConversion *anthy) : Predictor(cfg)
{
    convertor = anthy;
}


AnthyPrediction::~AnthyPrediction()
{
}



/*!
    \fn AnthyPrediction::getPredictionList(const WideString &str)
 */
ResultList AnthyPrediction::getPredictionList(const WideString &str)
{
    ResultList list;
    list.kType = PREDICTION;
    list.Title = utf8_mbstowcs(String(_("lookup result")));
    
    #ifdef HAS_ANTHY_PREDICTION
    String s;
    convertor->m_iconv.convert(s,str);
    anthy_set_prediction_string(convertor->context,s.c_str());
    struct anthy_prediction_stat pstat;
    anthy_get_prediction_stat(convertor->context,&pstat);
    

    for(int i = 0;i < pstat.nr_prediction;i ++) {
        char res[256];
        anthy_get_prediction(convertor->context,i,res,255);
        WideString w;
        convertor->m_iconv.convert(w,String(res));
        list.kouho.push_back(w);
    }
    #endif
    return list;

}


/*!
    \fn AnthyPrediction::disconnect()
 */
void AnthyPrediction::disconnect()
{
    return;
}


/*!
    \fn AnthyPrediction::connect()
 */
bool AnthyPrediction::connect()
{
    return convertor->connect();
}


/*!
    \fn AnthyPrediction::isConnected()
 */
bool AnthyPrediction::isConnected()
{
    return convertor->isConnected();
}


/*!
    \fn AnthyPrediction::getPropertyName()
 */
String AnthyPrediction::getPropertyName()
{
    return String(_("AnthyPrediction"));
}

/*!
    \fn AnthyPrediction::getName()
 */
String AnthyPrediction::getName()
{
    return String("AnthyPrediction");
}

/*!
    \fn AnthyPrediction::update(const WideString str,const WideString yomi)
 */
void AnthyPrediction::update(const WideString str,const WideString yomi)
{
    return;
}

