/*
 * commands_smtp.h -- This file is the header file for commands_smtp.c
 *
 * Created by: Trever Adams <tadams-lists@myrealbox.com> 26-Jan-2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

typedef struct _LIST {
	char *buffer;
	unsigned size;
	struct _LIST *next;
} LISTS;

int add_item(LISTS *LIST_HEAD, char *buffer, int size);
unsigned long compute_list_size(LISTS *LIST_HEAD);
void delete_list(LISTS *LIST_HEAD);
void init_list(LISTS *LIST_HEAD);
void build_body(LISTS *LIST_HEAD, char *body);
void do_send(int *state);
void process_mail(LISTS *LIST_HEAD, int *state);
void process_line(LISTS *LIST_HEAD, int *state);
void unbork_input(int argc, char *argv[]);
void httpmail_send(char *sendmsg_url, char *body, unsigned long body_len);
