/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* Id: $ */

/* vi:set ts=4 sw=4: */

#ifndef SKKCONF_PRIVATE_H
#define SKKCONF_PRIVATE_H
#include <glib.h>

#include "skktypes.h"

#define SKKCONF_DEFAULT_ITEM_SIZE	((sizeof (itemp))/(sizeof (itemp[0])))

SkkConfItem itemp[] = {
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_MODE_ABBREV, 
	"skk-abbrev-mode-string", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_NUM, SKKCONF_NUM_CANDIDATE_COUNT, 
	"skk-candidate-count", NULL, (gpointer)4, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_DABBREV_LIKE_COMPLETION, 
	"skk-dabbrev-like-completion", NULL, (gpointer)FALSE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_DATE_AD, 
	"skk-date-ad", NULL, (gpointer)FALSE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_DELETE_IMPLIES_KAKUTEI, 
	"skk-delete-implies-kakutei", NULL, (gpointer)TRUE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_DELETE_OKURI_WHEN_QUIT, 
	"skk-delete-okuri-when-quit", NULL, (gpointer)FALSE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_ECHO, 
	"skk-echo", NULL, (gpointer)TRUE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_EGG_LIKE_NEWLINE, 
	"skk-egg-like-newline", NULL, (gpointer)FALSE, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_MODE_HIRAKANA, 
	"skk-hirakana-mode-string", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_MODE_JISX0201_KANA, 
	"skk-jisx0201-kana-mode-string", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_MODE_JISX0208_LATIN, 
	"skk-jisx0208-latin-mode-string", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_JISYO, 
	"skk-jisyo", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_MODE_KATAKANA, 
	"skk-katakana-mode-string", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_MODE_LATIN, 
	"skk-latin-mode-string", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_OKURI_JISYO, 
	"skk-okuri-jisyo", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_USE_CANNA, 
	"skk-plugin-use-canna", NULL, (gpointer)FALSE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_USE_DICT, 
	"skk-plugin-use-dict", NULL, (gpointer)TRUE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_USE_LDICT, 
	"skk-plugin-use-ldict", NULL, (gpointer)TRUE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_USE_LOOK, 
	"skk-plugin-use-look", NULL, (gpointer)TRUE, FALSE},
	{SKKCONF_TYPE_BOOL, SKKCONF_BOOL_USE_POBOX, 
	"skk-plugin-use-pobox", NULL, (gpointer)FALSE, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_POBOX_SERVER_HOST, 
	"skk-pobox-server-host", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_POBOX_SERVER_PORT, 
	"skk-pobox-server-port", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_SERVER_HOST, 
	"skk-server-host", NULL, (gpointer)NULL, FALSE},
	{SKKCONF_TYPE_STRING, SKKCONF_STRING_SERVER_PORT, 
	"skk-server-port", NULL, (gpointer)NULL, FALSE},
};

#endif /* SKKCONF_PRIVATE_H */
