/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skkel.c,v 1.5 2003/02/19 17:44:51 famao Exp $ */

/* vi:set ts=4 sw=4: */

#include <string.h>
#include <stdio.h>
#include "skkel.h"

SkkLisp *
skk_lisp_new (void)
{
	SkkLisp *l;
	l = g_new0 (SkkLisp, 1);
	return l;
}

SkkLisp *
skk_lisp_new_with_value (const gchar *value, gint type, gint level)
{
	SkkLisp *l;
	l = skk_lisp_new ();
	if (value) {
		l->value = g_strdup (value);
	}
	l->type = type;
	l->level = level;
	return l;
}

void
skk_lisp_destroy (SkkLisp *lisp)
{
	if (!lisp)
		return;
	if (lisp->value) {
		g_free (lisp->value);
	}
	g_free (lisp);
	return;
}

GList *
skk_lisp_parse (const gchar *str) 
{
	GList *ret = NULL;
	SkkLisp *l;
	gchar *value,*copy,*tmp;
	gint level = 0;
	gboolean in_dq = FALSE;
	if (!str || !*str) 
		return NULL;
	tmp = copy = value = g_new0 (gchar, strlen (str) + 1);
	for (; str && *str; str++) {
		switch (*str) {
			case '(':
				level++;
				break;
			case ')':
				if (tmp == value) {
					value++;
					tmp++;
					break;
				}
				*value = '\0';
				l = skk_lisp_new_with_value (tmp, 0, level);
				value++;
				tmp = value;
				level--;
				ret = g_list_append (ret, l);
				break;
			case '"':
				in_dq = !in_dq;
				break;
			case ' ':
				if (in_dq) {
					*value = *str;
					value++;
					break;
				}
				if (tmp == value) {
					tmp++;
					value++;
					break;
				}
				*value = '\0';
				l = skk_lisp_new_with_value (tmp, 0, level);
				value++;
				tmp = value;
				ret = g_list_append (ret, l);
				break;
			default:
				*value = *str;
				value++;
				break;
		}
	}
	return ret;
}

#ifdef SKKLISP_DEBUG
int
main (void)
{
	GList *l;
	SkkLisp *lisp;
	gint i;
	gchar *str = "(concat \"fu ga\" \"hoge\")";
	l = skk_lisp_parse (str);
	for (; l; l = g_list_next (l)) {
		lisp = (SkkLisp *)l->data;
		for (i = 0; i < lisp->level; i++) {
			printf ("\t");
		}
		printf ("%s\n", lisp->value);
	}
	return 0;
}
#endif

