/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: skklookimpl.c,v 1.5 2003/02/19 17:44:52 famao Exp $ */

/* vi:set ts=4 sw=4: */


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "skklookimpl.h"
#include "skktypes.h"
#include "skkdictitem.h"


static SkkQueryFunctionImpl *get_new (SkkQuery *query);
static gboolean set_next (SkkQueryFunctionImpl *impl);
static gboolean set_prev (SkkQueryFunctionImpl *impl);
static gboolean set_nth (SkkQueryFunctionImpl *impl, gint nth);
static GList * do_query (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num);
static GList * completion (SkkQueryFunctionImpl *impl, const gchar *buf);
static void destroy (SkkQueryFunctionImpl *impl);
static const gchar *get_info (void);
static gint get_type (void);

static SkkQueryFunctionImpl lookimpl = 
{
	get_new,
	set_next,
	set_prev,
	set_nth,
	do_query,
	completion,
	NULL,
	destroy,
	get_info,
	get_type,
	NULL,
	NULL,
};

static const gchar *
get_info (void)
{
	return NULL;
}

static void
destroy (SkkQueryFunctionImpl *impl)
{
	SkkLookImpl *look;
	if (!impl)
		return;
	look = (SkkLookImpl *)impl;
	g_free (look);
	return;
}

static gint
get_type (void)
{
	return SKKQUERY_LOOK;
}

static GList *
do_query (SkkQueryFunctionImpl *impl, const gchar *buf, const gchar *okuri, gint *found_num)
{
	FILE *fp;
	gchar *exe = NULL;
	gchar lookbuf[128];
	gchar *keybuf;
	GList *ret = NULL;
	SkkDictItem *item;

	if (!buf)
		return NULL;
	/* check first char is ascii or not */
	if (!isascii (buf[0])) {
		return NULL;
	}
	if (buf[strlen (buf) - 1] == '*') {
		keybuf = g_strndup (buf, strlen (buf) - 1);
	} else {
		/* TODO */
		return NULL;
	}
	exe = g_strconcat (LOOK_PATH, " ", keybuf, NULL);
	fp = popen (exe, "r");
	if (!fp) {
		g_free (exe);
		g_free (keybuf);
		return NULL;
	}
	while (fgets (lookbuf, 128 , fp)) {
		if (lookbuf) {
			if (lookbuf[strlen (lookbuf) - 1] == '\n') {
				lookbuf[strlen (lookbuf) - 1] = '\0';
			}
		}
		item = skk_dict_item_new_with_value (lookbuf, NULL);
		ret = g_list_append (ret, item);
	}
	fclose (fp);
	g_free (exe);
	g_free (keybuf);
	return ret;
}

static GList *
completion (SkkQueryFunctionImpl *impl, const gchar *buf)
{
	FILE *fp;
	gchar *exe = NULL;
	gchar lookbuf[128];
	gchar *keybuf;
	GList *ret = NULL;

	if (!buf)
		return NULL;
	/* check first char is ascii or not */
	if (!isascii (buf[0])) {
		return NULL;
	}
	if (buf[strlen (buf) - 1] == '*') {
		keybuf = g_strndup (buf, strlen (buf) - 1);
	} else {
		/* TODO */
		keybuf = g_strdup (buf);
	}
	exe = g_strconcat (LOOK_PATH, " ", keybuf, NULL);
	fp = popen (exe, "r");
	if (!fp) {
		g_free (exe);
		g_free (keybuf);
		return NULL;
	}
	while (fgets (lookbuf, 128 , fp)) {
		if (lookbuf) {
			if (lookbuf[strlen (lookbuf) - 1] == '\n') {
				lookbuf[strlen (lookbuf) - 1] = '\0';
			}
			if (strlen (lookbuf) > 0) {
				ret = g_list_append (ret, g_strdup (lookbuf));
			}
		}
	}
	fclose (fp);
	g_free (exe);
	g_free (keybuf);
	return ret;
}

static gboolean
set_next (SkkQueryFunctionImpl *impl)
{
	return FALSE;
}

static gboolean
set_prev (SkkQueryFunctionImpl *impl)
{
	return FALSE;
}

static gboolean
set_nth (SkkQueryFunctionImpl *impl, gint nth)
{
	return FALSE;
}

static SkkQueryFunctionImpl *
get_new (SkkQuery *query)
{
	SkkLookImpl *look;
	look = g_new0 (SkkLookImpl, 1);
	look->impl = lookimpl;
	return (SkkQueryFunctionImpl *)look;
}

/* TODO dlopen */
#if 0
SkkQueryFunctionImpl *
impl_init (void)
{
	SkkQueryFunctionImpl *impl;
	impl = lookimpl.impl_new ();
	return impl;
}
#endif

SkkQueryFunctionImpl *
skk_look_new (SkkQuery *query)
{
	return get_new (query);
}

SkkQueryFunctionImpl *
impl_init (SkkQuery *query)
{
	return get_new (query);
}

#ifdef SKKLOOK_DEBUG
int
main (void)
{
	SkkQueryFunctionImpl *impl;
	GList *list;
	GList *tmp;
	impl = skk_look_new (NULL);
	list = impl->do_query (impl, "la", NULL, NULL);
	for (tmp = list; tmp; tmp = g_list_next (tmp)) {
		g_message ("%s\n", ((SkkDictItem *)tmp->data)->candidate);
	}
	return 0;
}
#endif
