#ifndef K3DSDK_HINTS_H
#define K3DSDK_HINTS_H

// K-3D
// Copyright (c) 1995-2006, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3d::frames class, useful for working with ranges of numbered files
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include "iunknown.h"

namespace k3d
{

/// Namespace reserved for "hint" object that pass metadata about an upstream change to downstream nodes
namespace hint
{

/// Hint object that indicates that a mesh property's topology has *not* been changed, just its attributes (point positions, etc)
class mesh_topology_unchanged :
	public iunknown
{
public:
	/// Convenience method that returns a reference to a static instance of mesh_topology_unchanged
	static mesh_topology_unchanged& instance();
};
	
} // namespace hint

} // namespace k3d

#endif // K3DSDK_HINTS_H

