#ifndef K3DSDK_IUSER_INTERFACE_PLUGIN_H
#define K3DSDK_IUSER_INTERFACE_PLUGIN_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares k3d::iuser_interface_plugin, an abstract interface that must be implemented by user interface plugins
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iunknown.h"

#include <string>
#include <vector>

// Forward declarations
namespace boost { namespace filesystem { class path; } }

namespace k3d
{

/// Abstract interface to common graphical-user-interface operations for use by objects
class iuser_interface_plugin :
	public virtual iunknown
{
public:
	/// Defines a collection of command-line arguments
	typedef std::vector<std::string> arguments_t;
	/// The plugin should parse the provided arguments, returning leftover arguments
	virtual const arguments_t parse_command_line(const arguments_t& Arguments, bool& Quit, bool& Error) = 0;
	/// Called by the host application to display informational messages during startup
	virtual void startup_message_handler(const std::string& Message) = 0;
	/// Called by the host application to display the "normal" user interface (and hide any startup / splash screens, etc)
	virtual void display_user_interface() = 0;
	/// Called by the host application to start the main event-loop (if any)
	virtual void start_event_loop() = 0;
	/// Called by the host application to stop the main event-loop (if any)
	virtual void stop_event_loop() = 0;

protected:
	iuser_interface_plugin() {}
	iuser_interface_plugin(const iuser_interface_plugin&) {}
	iuser_interface_plugin& operator = (const iuser_interface_plugin&) { return *this; }
	virtual ~iuser_interface_plugin() {}
};

} // namespace k3d

#endif // K3DSDK_IUSER_INTERFACE_PLUGIN_H


