
########################################################
# K3D_CHECK_OPENGL - tests for an installed OpenGL library

AC_DEFUN([K3D_CHECK_OPENGL], [
AC_SUBST(K3D_OPENGL_CFLAGS)
AC_SUBST(K3D_OPENGL_LIBS)
AC_MSG_CHECKING([for OpenGL])

k3d_check_opengl_lib_dir=""
k3d_check_opengl_directories="/usr/lib /usr/local/lib /usr/X11R6/lib"
for k3d_check_opengl_directory in $k3d_check_opengl_directories; do
	if test -f $k3d_check_opengl_directory/libGL.so || test -f $k3d_check_opengl_directory/libGL.a || test -f $k3d_check_opengl_directory/libGL.dll.a; then
		k3d_check_opengl_lib_dir=$k3d_check_opengl_directory
	fi
done

k3d_check_opengl_header_dir=""
k3d_check_opengl_directories="/usr/include /usr/local/include /usr/X11R6/include"
for k3d_check_opengl_directory in $k3d_check_opengl_directories; do
	if test -f "$k3d_check_opengl_directory/GL/gl.h"; then
		k3d_check_opengl_header_dir=$k3d_check_opengl_directory
	fi
done

if test -n "$k3d_check_opengl_lib_dir" && test -n "$k3d_check_opengl_header_dir"; then
	K3D_OPENGL_CFLAGS="-I$k3d_check_opengl_header_dir"
	K3D_OPENGL_LIBS="-L$k3d_check_opengl_lib_dir -lGL -lpthread"
	AC_MSG_RESULT([found in $k3d_check_opengl_lib_dir and $k3d_check_opengl_header_dir])
else
	AC_MSG_ERROR([OpenGL required but not found])
fi

])

########################################################
# K3D_CHECK_OPENGLU - tests for an installed OpenGLU library

AC_DEFUN([K3D_CHECK_OPENGLU], [
AC_SUBST(K3D_OPENGLU_CFLAGS)
AC_SUBST(K3D_OPENGLU_LIBS)
AC_MSG_CHECKING([for OpenGLU])

k3d_check_openglu_lib_dir=""
k3d_check_openglu_directories="/usr/lib /usr/local/lib /usr/X11R6/lib"
for k3d_check_openglu_directory in $k3d_check_openglu_directories; do
	if test -f $k3d_check_openglu_directory/libGLU.so || test -f $k3d_check_openglu_directory/libGLU.a || test -f $k3d_check_openglu_directory/libGLU.dll.a; then
		k3d_check_openglu_lib_dir=$k3d_check_openglu_directory
	fi
done

k3d_check_openglu_header_dir=""
k3d_check_openglu_directories="/usr/include /usr/local/include /usr/X11R6/include"
for k3d_check_openglu_directory in $k3d_check_openglu_directories; do
	if test -f "$k3d_check_openglu_directory/GL/gl.h"; then
		k3d_check_openglu_header_dir=$k3d_check_openglu_directory
	fi
done

if test -n "$k3d_check_openglu_lib_dir" && test -n "$k3d_check_openglu_header_dir"; then
	K3D_OPENGLU_CFLAGS="-I$k3d_check_openglu_header_dir"
	K3D_OPENGLU_LIBS="-L$k3d_check_openglu_lib_dir -lGLU"
	AC_MSG_RESULT([found in $k3d_check_openglu_lib_dir and $k3d_check_openglu_header_dir])
else
	AC_MSG_ERROR([OpenGLU required but not found])
fi

])

