#ifndef LIBK3DBITMAP_SIMPLE_BITMAP_MODIFIER_H
#define LIBK3DBITMAP_SIMPLE_BITMAP_MODIFIER_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <k3dsdk/bitmap_modifier.h>
#include <k3dsdk/persistent.h>
#include <k3dsdk/node.h>

namespace libk3dbitmap
{

class simple_bitmap_modifier :
	public k3d::bitmap_modifier<k3d::persistent<k3d::node> > 
{
	typedef k3d::bitmap_modifier<k3d::persistent<k3d::node> > base;

public:
	simple_bitmap_modifier(k3d::idocument& Document) :
		base(Document)
	{
	}

private:
	virtual void on_create_bitmap(const k3d::bitmap& Input, k3d::bitmap& Output)
	{
		Output.reset(Input.width(), Input.height());
	}
};

} // namespace libk3dbitmap

#endif // !LIBK3DBITMAP_SIMPLE_BITMAP_MODIFIER_H

