#ifndef NGUI_AQSIS_LAYER_CHOOSER_H
#define NGUI_AQSIS_LAYER_CHOOSER_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "ui_component.h"
#include <gtkmm/box.h>

namespace k3d { namespace aqsis { class ilayer_connection_property; } }
namespace k3d { class istate_recorder; }

namespace libk3dngui
{

class document_state;
	
namespace aqsis_layer_chooser
{

/////////////////////////////////////////////////////////////////////////////
// control

/// Provides a UI for choosing nodes (either existing, or newly-created) (i.e. the view and the controller from model-view-controller)
class control :
	public Gtk::VBox,
	public ui_component
{
	typedef Gtk::VBox base;

public:
	control(document_state& DocumentState, k3d::aqsis::ilayer_connection_property& Property, k3d::icommand_node& Parent, const std::string& Name, k3d::istate_recorder* const StateRecorder);

private:
	k3d::aqsis::ilayer_connection_property& m_property;
};

} // namespace aqsis_layer_chooser

} // namespace libk3dngui

#endif // NGUI_AQSIS_LAYER_CHOOSER_H


