/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <qfile.h>
#include <qtextstream.h>
#include <qiodevice.h>
#include <qstringlist.h>

#include <settings.h>
#include <file.h>
#include <entry.h>
#include <element.h>
#include <macro.h>
#include <comment.h>
#include <fileexporter.h>

namespace BibTeX
{

    File::File( ) : QObject( ), m_preamble( QString::null )
    {
        // nothing
    }

    File::~File()
    {
        for ( ElementList::iterator it = elements.begin(); it != elements.end(); it++ )
            delete * it;
    }

    unsigned int File::count ()
    {
        return elements.count();
    }

    Element* File::at( const unsigned int index )
    {
        return * ( elements.at( index ) );
    }

    void File::append( const File *other, const Element *after )
    {
        for ( ElementList::const_iterator it = other->constBegin(); it != other->constEnd(); it++ )
            appendElement( cloneElement( *it ), after );
    }

    void File::appendElement( Element *element, const Element *after )
    {
        if ( after == NULL )
            elements.append( element );
        else
        {
            for ( ElementList::iterator it = elements.begin() ; it != elements.end(); it++ )
                if ( ( *it ) == after )
                {
                    elements.insert( ++it, element );
                    break;
                }
        }
    }

    void File::deleteElement( Element *element )
    {
        for ( ElementList::iterator it = elements.begin(); it != elements.end(); it++ )
            if ( *it == element )
            {
                elements.remove( it );
                break;
            }

        delete element;
    }

    Element* File::cloneElement( Element *element )
    {
        Entry * entry = dynamic_cast<Entry*>( element );
        if ( entry )
            return new Entry( entry );
        else
        {
            Macro *macro = dynamic_cast<Macro*>( element );
            if ( macro )
                return new Macro( macro );
            else
            {
                Comment *comment = dynamic_cast<Comment*>( element );
                if ( comment )
                    return new Comment( comment );
                else
                    return NULL;
            }
        }
    }

    QString File::preamble()
    {
        return m_preamble;
    }

    void File::setPreamble( const QString &preamble )
    {
        m_preamble = preamble;
    }

    Element *File::containsKey( const QString &key )
    {
        for ( ElementList::iterator it = elements.begin(); it != elements.end(); it++ )
        {
            Entry* entry = dynamic_cast<Entry*>( *it );
            if ( entry != NULL )
            {
                if ( entry->id() == key )
                    return entry;
            }
            else
            {
                Macro* macro = dynamic_cast<Macro*>( *it );
                if ( macro != NULL )
                {
                    if ( macro->key() == key )
                        return macro;
                }
            }
        }

        return NULL;
    }

    File::ElementList::iterator File::begin()
    {
        return elements.begin();
    }

    File::ElementList::iterator File::end()
    {
        return elements.end();
    }

    File::ElementList::const_iterator File::constBegin() const
    {
        return elements.constBegin();
    }

    File::ElementList::const_iterator File::constEnd() const
    {
        return elements.constEnd();
    }

    QStringList File::getAllValues( const EntryField::FieldType fieldType ) const
    {
        QStringList result;
        for ( ElementList::const_iterator it = elements.begin(); it != elements.end(); it++ )
        {
            Entry* entry = dynamic_cast<Entry*>( *it );
            if ( entry != NULL )
            {
                EntryField * field = entry->getField( fieldType );
                if ( field != NULL )
                {
                    ValuePersons * persons = dynamic_cast<ValuePersons*>( field->value() );
                    if ( persons != NULL )
                    {
                        QValueList<Person*> list = persons->persons();
                        for ( QValueList<Person*>::ConstIterator it = list.begin();it != list.end();++it )
                        {
                            QString text = ( *it ) ->text();
                            if ( !result.contains( text ) )
                                result.append( text );
                        }
                    }
                    else
                    {
                        QString text = field->value() ->plainString();
                        if ( !result.contains( text ) )
                            result.append( text );
                    }
                }
            }
        }

        result.sort();
        return result;
    }
}

#include "file.moc"

