/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <qlayout.h>
#include <qcombobox.h>
#include <qapplication.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qtoolbutton.h>

#include <klistbox.h>
#include <kdialog.h>
#include <klocale.h>
#include <kiconloader.h>

#include <settings.h>
#include "sidebar.h"

namespace KBibTeX
{

    const BibTeX::EntryField::FieldType SideBar::importantFields[ 5 ] = {BibTeX::EntryField::ftAuthor, BibTeX::EntryField::ftBookTitle, BibTeX::EntryField::ftJournal, BibTeX::EntryField::ftTitle, BibTeX::EntryField::ftYear};

    SideBar::SideBar( QWidget *parent, const char *name )
            : QWidget( parent, name ), m_bibtexFile( NULL )
    {
        setupGUI();
    }

    SideBar::~SideBar()
    {
        // nothing
    }

    void SideBar::restoreState()
    {
        Settings * settings = Settings::self();
        if ( settings->editing_UseSpecialFont )
            m_listAvailableItems->setFont( settings->editing_SpecialFont );
        else
            m_listAvailableItems->setFont( KGlobalSettings::generalFont() );
    }

    void SideBar::refreshLists( const BibTeX::File *bibtexFile )
    {
        if ( bibtexFile != NULL )
            m_bibtexFile = bibtexFile;

        QApplication::setOverrideCursor( Qt::waitCursor );
        setEnabled( FALSE );

        BibTeX::EntryField::FieldType fieldType = m_buttonToggleShowAll->isOn() ? ( BibTeX::EntryField::FieldType ) ( m_listTypeList->currentItem() + ( int ) BibTeX::EntryField::ftAbstract ) : importantFields[ m_listTypeList->currentItem() ];

        m_listAvailableItems->clear();
        if ( m_bibtexFile != NULL )
            m_listAvailableItems->insertStringList( m_bibtexFile->getAllValues( fieldType ) );

        setEnabled( TRUE );
        QApplication::restoreOverrideCursor();
    }

    void SideBar::resizeEvent( QResizeEvent *event )
    {
        QSize widgetSize = size();
        setEnabled( widgetSize.width() > 3 && widgetSize.height() > 3 );
        QWidget::resizeEvent( event );
    }

    void SideBar::setupGUI()
    {
        QGridLayout * layout = new QGridLayout( this, 2, 2, 0, KDialog::spacingHint() );
        layout->setColStretch( 0, 0 );
        layout->setColStretch( 1, 10 );

        m_buttonToggleShowAll = new QToolButton( this );
        layout->addWidget( m_buttonToggleShowAll, 0, 0 );
        QIconSet showAllPixmap = KGlobal::iconLoader() ->loadIconSet( "taskbar", KIcon::Small );
        m_buttonToggleShowAll->setIconSet( showAllPixmap );
        m_buttonToggleShowAll->setToggleButton( TRUE );
        QToolTip::add( m_buttonToggleShowAll, i18n( "Toggle between showing all fields or only important fields" ) );

        m_listTypeList = new QComboBox( FALSE, this );
        layout->addWidget( m_listTypeList, 0, 1 );
        QToolTip::add( m_listTypeList, i18n( "Filter this sidebar for a given field" ) );

        m_listAvailableItems = new KListBox( this );
        layout->addMultiCellWidget ( m_listAvailableItems, 1, 1, 0, 1 );

        connect( m_listAvailableItems, SIGNAL( selectionChanged( QListBoxItem * ) ), this, SLOT( prepareSearch( QListBoxItem * ) ) );
        connect( m_listTypeList, SIGNAL( activated ( int ) ), this, SLOT( refreshLists() ) );
        connect( m_buttonToggleShowAll, SIGNAL( toggled( bool ) ), this, SLOT( toggleShowAll( bool ) ) );


        toggleShowAll( FALSE );
    }

    void SideBar::prepareSearch( QListBoxItem *item )
    {
        if ( item != NULL )
        {
            BibTeX::EntryField::FieldType fieldType = m_buttonToggleShowAll->isOn() ? ( BibTeX::EntryField::FieldType ) ( m_listTypeList->currentItem() + ( int ) BibTeX::EntryField::ftAbstract ) : importantFields[ m_listTypeList->currentItem() ];
            emit selected( item->text(), fieldType );
        }
    }

    void SideBar::toggleShowAll( bool showAll )
    {
        m_listTypeList->clear();

        if ( showAll )
        {
            for ( int i = ( int ) BibTeX::EntryField::ftAbstract; i <= ( int ) BibTeX::EntryField::ftYear; i++ )
            {
                BibTeX::EntryField::FieldType fieldType = ( BibTeX::EntryField::FieldType ) i;
                m_listTypeList->insertItem( Settings::fieldTypeToI18NString( fieldType ) );
            }
            m_listTypeList->setCurrentItem( ( int ) BibTeX::EntryField::ftAuthor );
        }
        else
        {
            for ( int i = 0;i < 5;i++ )
                m_listTypeList->insertItem( Settings::fieldTypeToI18NString( importantFields[ i ] ) );
            m_listTypeList->setCurrentItem( 0 );
        }

        refreshLists();
    }
}
#include "sidebar.moc"
