/***************************************************************************
 *   Copyright (C) 2005 by Peter Müller   *
 *   pmueller@cs.tu-berlin.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdlib.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qcolor.h>
#include <kapplication.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kurlrequester.h>
#include <knuminput.h>
#include <kconfig.h>
#include <kglobal.h>
#include "kcometen3.h"
#include "kcometen3ui.h"

//! libkscreensaver interface
extern "C"
{
    const char *kss_applicationName = "kcometen3.kss";
    const char *kss_description = I18N_NOOP( "KCometen3" );
    const char *kss_version = "2.2.0";

    KCometen3 *kss_create( WId id )
    {
        KGlobal::locale()->insertCatalogue("kcometen3");
        return new KCometen3( id );
    }

    QDialog *kss_setup()
    {
        KGlobal::locale()->insertCatalogue("kcometen3");
        return new KCometen3Setup();
    }
}

//-----------------------------------------------------------------------------
//! dialog to setup screen saver parameters
KCometen3Setup::KCometen3Setup( QWidget *parent, const char *name )
        : KCometen3UI( parent, name, TRUE )
{
    /// @todo
    //Connect your signals and slots here to configure the screen saver.
    connect( OkayPushButton, SIGNAL( released() ),
             SLOT( slotOkPressed() ) );
    connect( CancelPushButton, SIGNAL( released() ),
             SLOT( slotCancelPressed() ) );
	
	readSettings();
	
	kURLRequesterRandomDirectory->setMode(KFile::Directory);
}


//! read settings from config file
void KCometen3Setup::readSettings()
{
    KConfig *config = KGlobal::config();
    config->setGroup( "Settings" );
	
	// options
	comboBoxColor->setCurrentItem(config->readNumEntry("color", 0));
	checkFreeCamera->setChecked(config->readBoolEntry("freecamera", true));
	kDoubleNumInputCamSpeed->setValue(
		config->readDoubleNumEntry("freecamspeed", 1.5));
	kDoubleNumInputInterval->setValue(
		config->readDoubleNumEntry("interval", 1.25f));
	kIntNumInputFps->setValue(config->readNumEntry("maxfps", 60));
	kDoubleNumInputTimeScale->setValue(
		config->readDoubleNumEntry("timescale", 1.0));
	kDoubleNumInputSizeScale->setValue(
		config->readDoubleNumEntry("sizescale", 2.5));	
	// effects
	checkBlitz->setChecked(config->readBoolEntry( "lightning", true ));
	checkSplitComet->setChecked(config->readBoolEntry( "splitcomet", true ));
	checkRotateComet->setChecked(config->readBoolEntry( "rotatecomet", true ));
	checkCurveComet->setChecked(config->readBoolEntry( "curvecomet", true ));
	checkRotCam->setChecked(config->readBoolEntry( "matrix", true ));
	checkSlowmotion->setChecked(config->readBoolEntry( "slowmotion", true ));
	// Background
	buttonGroupBackground->setButton(config->readNumEntry("bgtype", 0));
	kURLRequesterFile->setURL(config->readPathEntry("bgfile",""));
	comboBoxBgSize->setCurrentItem(config->readNumEntry("bgsize", 2));
	kURLRequesterRandomDirectory->setURL(config->readPathEntry("bgdir",""));

}


//! Ok pressed - save settings and exit
void KCometen3Setup::slotOkPressed()
{
    KConfig *config = KGlobal::config();
    config->setGroup( "Settings" );
	
	// options
	config->writeEntry("color", comboBoxColor->currentItem());
	config->writeEntry("maxfps", kIntNumInputFps->value());
	config->writeEntry("interval", kDoubleNumInputInterval->value());
	config->writeEntry("freecamera", checkFreeCamera->isChecked());
	config->writeEntry("freecamspeed", kDoubleNumInputCamSpeed->value());
	config->writeEntry("timescale",kDoubleNumInputTimeScale->value());
	config->writeEntry("sizescale",kDoubleNumInputSizeScale->value());
	// effects
	config->writeEntry("lightning", checkBlitz->isChecked());
	config->writeEntry("splitcomet", checkSplitComet->isChecked());
	config->writeEntry("rotatecomet", checkRotateComet->isChecked());
	config->writeEntry("curvecomet", checkCurveComet->isChecked());
	config->writeEntry("matrix", checkRotCam->isChecked());
	config->writeEntry("slowmotion", checkSlowmotion->isChecked());
	// background
	config->writeEntry("bgtype", buttonGroupBackground->selectedId());
	config->writePathEntry("bgfile", kURLRequesterFile->url());
	config->writeEntry("bgsize", comboBoxBgSize->currentItem());
	config->writeEntry("bgdir", kURLRequesterRandomDirectory->url());

	config->sync();

    accept();
}

void KCometen3Setup::slotCancelPressed()
{
    reject();
}
//-----------------------------------------------------------------------------


KCometen3::KCometen3( WId id ) : KScreenSaver( id )
{
	kglcometen3 = new KGLCometen3();
	
	kglcometen3->start(KGlobal::config());
	
	embed(kglcometen3);
	

	kglcometen3->show();
}

KCometen3::~KCometen3()
{
	delete kglcometen3;
}

