/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen <kdebluetooth@schaettgen.de>    *
 *   Copyright (C) 2004 by Alex Ibrado <alex@kdex.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KBEMUSEDSRV_H_
#define _KBEMUSEDSRV_H_

#define RECURSIVE true
#define NONRECURSIVE false

#include <kmainwindow.h>
#include <qguardedptr.h>
#include <qptrlist.h>
#include <vector>
#include <qdir.h>
#include "controller.h"
#include <libkbluetooth/rfcommsocket.h>
#include <libkbluetooth/deviceaddress.h>
#include <ksystemtray.h>
#include <kdesktopfile.h>
#include "dcopinterface.h"

class MainDialogBase;
class LogDialogBase;
class KDialogBase;
class KToggleAction;
class KAboutApplication;

/**
 * @short Application Main Window
 * @author Fred Schaettgen <kbemusedsrv@0xF.de>
 * @version 0.1
 */
class MainDialog : public KSystemTray, 
    virtual public DCOPInterface 
{
    Q_OBJECT
public:
    MainDialog(int s, QString addr, QString name);
    virtual ~MainDialog();

protected:
    virtual void closeEvent(QCloseEvent *e);

private:
    MainDialogBase *configDlg;
    KDialogBase *configDlgFrame;
    LogDialogBase *logDlg;
    KDialogBase *logDlgFrame;
    KAboutApplication *aboutDlg;

    KAction *configAction;
    KAction *logAction;

    KDesktopFile *kdf;
    KConfig *cfg;

    bool isStandalone;
    bool acceptClose;

    bool configDlgIsSetup;

    struct MediaDirInfo {
        QString path;
        QString alias;
        QString controllerName;
    };
    std::vector<MediaDirInfo> mediaDirInfos;

    QPtrList<Controller> controllers;
    QGuardedPtr<Controller> curController;
    int curControllerIndex;

    KBluetooth::RfcommSocket *socket;
    int curRfcommChannel;
    int activeControllers;
    void handlePacket();

    void addRecvLogTxt(QString text);
    void addSendLogTxt(QString text);

    QString readFilenameStructure();
    void sendPathList(QStringList pathlist, Q_UINT8 dir_type);
    void sendSubPathList(QStringList pathlist, Q_UINT8 dir_type);
    void sendDirNode(Q_UINT8 nodeType, QString name);

    QStringList getControllerList();
    Controller* getControllerByName(QString name);
    Controller* getControllerByName(QString name, int& index);
    QStringList getDirList(QString targetpath, bool recurse);
    QStringList getRecursiveDirList(QDir dir);
    QString expandFilename(QString filename, QString* controller = NULL);

    void loadConfig();
    void setupConfigDlg();

    void refreshControllersTab();
    void refreshControllersTab(int activeCnt, int startupIndex);
    void refreshAliasesTab();
    void refreshClientTab();
    void refreshServerTab();
    void refreshWarningsButton();

    void runShutCommand(QString entry);

    enum LaunchTrigger { TRIGGERS_START, STARTUP, RESELECT, INITIALCMD, USERPREFS, TRIGGERS_END };
    void launchApp(LaunchTrigger trigger);

    static const Q_UINT8 ROOT_NODE = (0x0 << 4);
    static const Q_UINT8 CHILD_NODE = (0x1 << 4);
    static const Q_UINT8 ONLY_CHILD_NODE = (0x2 << 4);
    static const Q_UINT8 SIBLING_NODE = (0x3 << 4);
    static const Q_UINT8 LAST_SIBLING_NODE = (0x4 << 4);

    static const Q_UINT8 DRIVE_NODE = (0x0);
    static const Q_UINT8 DIR_NODE = (0x1);
    static const Q_UINT8 FILE_NODE = (0x2);
    static const Q_UINT8 UNEXPANDED_DIR_NODE = (0x3);

public slots:
    void configure(); // Also DCOP

private slots:
    void slotSocketReadyRead();
    void slotShowConfig();
    void slotShowLog();
    void slotClose();
    void slotShowAbout();
    void slotApplyConfig();
    void slotApplyConfigOk();
    void slotAddDir();
    void slotDeleteDir();
    //void slotCtrlTableCellChanged(int row, int col);
    void slotDirTableCellChanged(int row, int col);
    void slotShutFxSelected(int id);
    void slotRestoreWarnings();
    void slotReloadConfig();
    void slotExitStandalone();
    void slotQuitSelected();
};

#endif // _KBEMUSEDSRV_H_
