/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include <qmessagebox.h>
#include <qdir.h>
#include <unistd.h>
#include <kstandarddirs.h>
#include <kprocess.h>

#include "KBlueLockConfig.h"
#include "KBlueLockHandleProcess.h"
#include "KBlueLockScanner.h"

static const char *description =
    I18N_NOOP("KDE Bluetooth Screen Lock");

static const char *version = "0.0";

static KCmdLineOptions options[] =
{
   { "forcelock", I18N_NOOP("Force screen locking"), 0 },
   { "dontlock", I18N_NOOP("Only start screen saver"), 0 },
   { "configure", I18N_NOOP("Configure screen saver parameters"), 0 },
   { 0, 0, 0 }
};

int main( int argc, char *argv[] )
{
    KAboutData aboutData("kbluelock", I18N_NOOP("KDE Bluetooth Screen Lock"),
                         version, description, KAboutData::License_GPL,
                         "(c) 2003, Mattia Merzi\n");
    aboutData.addAuthor("Mattia Merzi",
              I18N_NOOP("Author, Maintainer"),
                        "ottobit@ferrara.linux.it");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    KApplication a;

    if (args->isSet("configure")) {
      KBlueLockConfig* dw = new KBlueLockConfig();
      dw->show();
      a.setTopWidget(dw);
      a.exec();
    } else {
      KBlueLockHandleProcess* process = new KBlueLockHandleProcess();
      KBlueLockScanner* scanner = new KBlueLockScanner();
      process->setParams(args->isSet("forcelock"),args->isSet("dontlock"));
      process->start();

      if(!args->isSet("dontlock")) {
        scanner = new KBlueLockScanner();
        scanner->registerLockProcess(process);
        if (scanner->init()) {
            scanner->start();
            a.exec();
        } else {
            QMessageBox::critical(NULL,"Error !",
              "Cannot start bluetooth.\nMaybe the bluetooth hardware is not present\n"
              "or is in use by another process");
            process->terminate();
            exit(-1);
        }
      } else {
        a.exec();
      }
    }

    return 0;
}
