//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qlayout.h>

#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kjanuswidget.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvbox.h>
#include <dcopclient.h>
#include "servicetab.h"
#include "confirmationtab.h"
#include "scantab.h"
#include <libkbluetoothd/checkdaemon.h>

#include "kcm_kbluetoothd.h"

kcm_kbluetoothd::kcm_kbluetoothd(QWidget *parent, const char *name)
    : KCModule(parent, name)
{
    QVBoxLayout* mainLayout = new QVBoxLayout(this);
    if (KBluetoothd::checkDaemon()) {
        tabContainer = new KJanusWidget(this, "tabcontainer", KJanusWidget::Tabbed);
        mainLayout->addWidget(tabContainer);

        QVBox* serviceBox = tabContainer->addVBoxPage(i18n("Local Services"));
        serviceTab = new ServiceTab(serviceBox, "servicetab");
        connect(serviceTab, SIGNAL(dirty()), this, SLOT(configChanged()));

        QVBox* confirmationBox = tabContainer->addVBoxPage(i18n("Confirmation"));
        confirmationTab = new ConfirmationTab(confirmationBox, "confirmationtab");
        connect(confirmationTab, SIGNAL(dirty()), this, SLOT(configChanged()));

        QVBox* scanBox = tabContainer->addVBoxPage(i18n("Device Discovery"));
        scanTab = new ScanTab(scanBox, "scantab");
        connect(scanTab, SIGNAL(dirty()), this, SLOT(configChanged()));

        load();

        KConfig* config = instance()->config();
        config->setGroup("kcm_kbluetoothd_global");
        tabContainer->showPage(config->readNumEntry("currentTab", 0));
    }
    else {
        QLabel *label = new QLabel(i18n("<p>Cannot access the KDE Bluetooth Daemon \
(kbluetoothd).<br/>\n You have to start it before using this configuration page.</p>"),this);
        mainLayout->addWidget(label);
    }
};


kcm_kbluetoothd::~kcm_kbluetoothd()
{
    KConfig* config = instance()->config();
    config->setGroup("kcm_kbluetoothd_global");
    config->writeEntry("currentTab", tabContainer->activePageIndex());    
}

void kcm_kbluetoothd::load()
{
}


void kcm_kbluetoothd::defaults()
{
    if (serviceTab) serviceTab->defaults();
    if (confirmationTab) confirmationTab->defaults();
    if (scanTab) scanTab->defaults();
    emit changed(true);
}


void kcm_kbluetoothd::save()
{
    if (serviceTab) serviceTab->apply();
    if (confirmationTab) confirmationTab->apply();
    if (scanTab) scanTab->apply();
    emit changed(true);
}


int kcm_kbluetoothd::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


void kcm_kbluetoothd::configChanged()
{
    // insert your saving code here...
    emit changed(true);
}


QString kcm_kbluetoothd::quickHelp() const
{
    return i18n("<h1>KBluetoothD</h1>\
This module configures kbluetoothd, the meta server of the KDE Bluetooth Framework. \
It manages Bluetooth services offered by your system and can launch \
programs when Bluetooth devices were detected.");
}


extern "C"
{
    KCModule *create_kbluetoothd(QWidget *parent, const char */*name*/)
    {
        KGlobal::locale()->insertCatalogue("kbluetoothd");
        KGlobal::locale()->insertCatalogue("kbluetoothdcm");
        return new kcm_kbluetoothd(parent, "kbluetoothd");
    }
}

#include "kcm_kbluetoothd.moc"
