/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klocale.h>

#include <qtextstream.h>
#include <qtextcodec.h>
#include <qcstring.h>
#include <qstring.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qmap.h>

#include <qvalidator.h>
#include <qregexp.h>

#include <kmessagebox.h>

#ifdef HAVE_QOBEX_IRDA
#include <qobex/qobexirdatransport.h>
#endif

#include "discoverabledevicewidget.h"
#include "irdadevicewidget.h"

IrDADeviceWidget::IrDADeviceWidget( QWidget* parent, const char* name, WFlags fl )
  : DiscoverableDeviceWidget( parent, name, fl )
{
  QRegExp rx( "([0-9A-Fa-f]{2}:){3}[0-9A-Fa-f]{2}" );
  QValidator* validator = new QRegExpValidator( rx, mHandInputInput, "addressvalidator" );

  mHandInputInput->setValidator( validator );
  mHandInputInput->setInputMask( ">NN:NN:NN:NN" );
  mHandInputInput->setText( "00:00:00:00" );
}

IrDADeviceWidget::~IrDADeviceWidget()
{
}

QString IrDADeviceWidget::anyDevice() const
{
  return "00:00:00:00";
}

void IrDADeviceWidget::slotDiscoveryButtonPressed()
{
  clearDiscoveredDevices();

#ifdef HAVE_QOBEX_IRDA
  QMap<Q_UINT32,QString> devs = QObexIrDATransport::discoverDevices();

  QMap<Q_UINT32,QString>::Iterator it;
  for( it = devs.begin(); it != devs.end(); ++it ) {
    // display discovered device.
    QString addr = QObexIrDATransport::address2String( it.key() );
    discoveredDevice( it.data(), addr, true );
  }
#endif
}

#include "irdadevicewidget.moc"
