/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef OBEX_H
#define OBEX_H

#include <qwidget.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvariant.h>

#include <kcmodule.h>
#include <kaboutdata.h>

class QGridLayout;
class QListView;
class QPushButton;
class QLabel;

class KObexConfigWidget
  : public KCModule {
  Q_OBJECT
public:
  KObexConfigWidget( QWidget *, const char * = 0, const QStringList& =QStringList() );
  ~KObexConfigWidget();

  void load();
  void save();
  QString quickHelp() const;
  const KAboutData* aboutData() const;

public slots:
  void slotRemove();
  void slotAdd();
  void slotEdit();
  void slotSelectionChanged();

private:
  // Widgets used here
  // Top widget.
  QGridLayout* mTopWidgetLayout;
  // See what aliases are configured.
  QListView* mListView;
  // Buttons to modify the list.
  QPushButton* mRemoveButton;
  QPushButton* mAddButton;
  QPushButton* mEditButton;
  // Some text here ...
  QLabel* lblIntro;
  
  // Implementation details.
  KAboutData *mAboutData;
  // The configuration file to use.
  KConfig* mObexConfig;
};

#endif
