/***************************************************************************
                           dscalerfiltergreedyh.cpp
                           ------------------------
    begin                : Wed Jul 21 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * GreedyH algorithm taken from DScaler.
 * Copyright (c) 2001 Tom Barry.  All rights reserved.
 *
 * Ported by: Dirk Ziegelmeier
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <stdlib.h>

#include <klocale.h>

#include "dscalerfiltergreedyh.h"
#include "greedyhmacros.h"
#include "x86-64_macros.inc"

DScalerFilterGreedyH::DScalerFilterGreedyH()
    : KdetvDScalerFilter(i18n("GreedyH")),
      GreedyMaxComb(MAXCOMB_DEFAULT),
      GreedyMotionThreshold(MOTIONTHRESHOLD_DEFAULT),
      GreedyMotionSense(MOTIONSENSE_DEFAULT)
{
}


DScalerFilterGreedyH::~DScalerFilterGreedyH()
{
}


#define IS_SSE
#define SSE_TYPE SSE
#define FUNCT_NAME filterDScaler_SSE
#include "greedyh.asm"
#undef SSE_TYPE
#undef IS_SSE
#undef FUNCT_NAME

#define IS_3DNOW
#define FUNCT_NAME filterDScaler_3DNOW
#define SSE_TYPE 3DNOW
#include "greedyh.asm"
#undef SSE_TYPE
#undef IS_3DNOW
#undef FUNCT_NAME

#define IS_MMX
#define SSE_TYPE MMX
#define FUNCT_NAME filterDScaler_MMX
#include "greedyh.asm"
#undef SSE_TYPE
#undef IS_3DNOW
#undef FUNCT_NAME
