/*
 *
 * Copyright (C) 2002-2003 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#include <qwidget.h>
#include <klocale.h>
#include "haze.h"
#include <kdebug.h>
#include <qpoint.h>
#include <qpalette.h>
#include <qfont.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qimage.h>

#include <X11/Xlib.h>

KdetvHaze::KdetvHaze(Kdetv *ktv, QWidget *parent, const char* name)
    : KdetvOSDPlugin(ktv, "haze-osd",parent, name),
      _lower(parent, "HAZE OSD Text"), 
      _cc(parent, "HAZE OSD Captioning Text"),
      _parent(parent)
{
    QPalette p;

	connect(&_timer, SIGNAL(timeout()), this, SLOT(clear()));
	connect(parent, SIGNAL(resized(int,int)), this, SLOT(viewResized(int,int)));

	p = _lower.palette();
	p.setColor(QColorGroup::Foreground, Qt::green);
	p.setColor(QColorGroup::Background, Qt::black);
	_lower.setPalette(p);
	p.setColor(QColorGroup::Foreground, Qt::white);
	_cc.setPalette(p);

	clear();
	_cc.clear();
	_cc.hide();
	_lower.clear();
	_lower.hide();

	viewResized(parent->width(), parent->height());
}

KdetvHaze::~KdetvHaze()
{
    kdDebug() << "Haze: destroying plugin." << endl;
	clear();
	_cc.clear();
	_cc.hide();
}


void KdetvHaze::displayLower()
{
	_lower.resize(_lower.minimumSizeHint());
	_lower.move(_parent->width()-_lower.width()-20, 20);
	_lower.updateMask();
	_lower.show();
}

void KdetvHaze::displayMisc(const QString& text)
{
	_lower.setText(text);
	displayLower();
	_timer.start(2000);
}

void KdetvHaze::displayChannel(int channel, const QString& name)
{
	if (name.isEmpty())
		_lower.setText(QString::number(channel));
	else _lower.setText(QString("%1 - %2").arg(channel).arg(name));
	displayLower();
	_timer.start(2000);
}

void KdetvHaze::displayMuted(bool muted)
{
	if (muted) {
		_lower.setText("MUTE");
		displayLower();
	} else {
		clear();
	}
}

void KdetvHaze::displayVolume(int vol)
{
	_lower.setText(QString("vol %1%").arg(vol));
	displayLower();
	_timer.start(2000);
}

void KdetvHaze::displayCC( const QString &text )
{
	if (text.isEmpty()) {
		_cc.hide();
		_cc.clear();
		return;
	}
	_cc.setText(text);
	_cc.show();
	_cc.resize(_cc.minimumSizeHint());
	_cc.move((_parent->width()-_cc.width())/2, _parent->height() - 20 - _cc.height());
}

void KdetvHaze::clear()
{
	//_lower.clear();
	_lower.hide();
	_timer.stop();
}

void KdetvHaze::viewResized(int w, int /*h*/)
{
	QFont f = _lower.font();
	//kdDebug() << "haze font resized to " << w / 15 << endl;
	f.setPixelSize(w / 15);
	f.setBold(true);
	_lower.setFont(f);
	if (_lower.isVisible()) {
        _lower.resize(_lower.minimumSizeHint());
        _lower.move(_parent->width()-_lower.width()-20, 20);
	}
	f = _cc.font();
	//kdDebug() << "haze font resized to " << w / 15 << endl;
	f.setPixelSize(w / 15);
	_cc.setFont(f);
	if (_cc.isVisible()) {
        _cc.resize(_cc.minimumSizeHint());
        _cc.move((_parent->width() - _cc.width())/2, 
                 _parent->height() - 20 - _cc.height());
	}
}


void KdetvHaze::colourKeyChanged(QColor key)
{
    QPalette p;
	p = _lower.palette();
	p.setColor(QColorGroup::Background, key);
	_lower.setPalette(p);
}



TransparentLabel::TransparentLabel(QWidget *parent, const char *name)
    : QLabel(parent, name)
{
}

TransparentLabel::~TransparentLabel()
{
}


/* Inspired by Jefferson code by Neil Stevens */
void TransparentLabel::updateMask()
{
    QColor bg(qRgb(255, 255, 255));
    QRgb fg = qRgb(0, 0, 0);
    QPalette p = palette();
    QPalette q = palette();
    q.setColor(QColorGroup::Foreground, QColor(fg));
    q.setColor(QColorGroup::Background, bg);
    setPalette(q);
    QImage result = QPixmap::grabWidget(this).convertToImage();

    int w = result.width();
    int h = result.height();

    int total = w * h;
    unsigned int *data = (unsigned int *)result.bits();
	for (int cur = w; cur < (total - w); ++cur) {
		if (QColor(data[cur]) != bg) {
			data[cur] = fg;
		}
	}

    QBitmap bm;
	bm.convertFromImage(result);
	setMask(bm);
	setPalette(p);
}


extern "C" {
    KDETV_EXPORT KdetvHaze* create_haze(Kdetv *ktv, QWidget *w)
    {
        KdetvHaze *qv;

        if (!w)
            return NULL;
        qv = new KdetvHaze(ktv, w);
        return qv;
    }

}

#include "haze.moc"

