/***************************************************************************
 *   Copyright (C) 2003 by Bert Speckels                                   *
 *   bert.speckels@web.de                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "LogService.h"
// #include <iostream>
#include <qdatetime.h>
#include <qstring.h>
#include <kdebug.h>

using namespace std;

int LogService::logCategories  = 65535;
int LogService::logLevel       = 99;

bool LogService::doLogConstruct = false;
bool LogService::doLogCall      = false;
bool LogService::doLogInfo      = false;


LogService::LogService() {

}

LogService::~LogService() {

}

QString LogService::categoryText(int category) {
  switch (category) {
    case CAT_KICKPIM:    return "KickPIM ";
    case CAT_CONTACTS:   return "Contacts";
    case CAT_EVENTS:     return "Events  ";
    case CAT_MAIL:       return "Email   ";
    case CAT_REPOSITORY: return "Reposit.";
    default:             return "        ";
  }
}

QString LogService::levelText(int level) {
  switch (level) {
    case LVL_INFO:    return " ";
    case LVL_WARN:    return "?";
    case LVL_ERROR:   return "!";
    case LVL_FATAL:   return "X";
    default:          return " ";
  }
}

void LogService::call(QString className, QString methodName ) {
  if (logLevel<LVL_DEBUG) return;
  kdDebug() << QTime::currentTime().toString()
            << " >>" << categoryText()
            << " "   << className << "::" << methodName << endl;
}

void LogService::construct(QString className ) {
  if (logLevel<LVL_DEBUG) return;
  kdDebug() << QTime::currentTime().toString()
            << " +>" << categoryText()
            << " "   << className << " (construct)" << endl;
}

void LogService::destruct(QString className ) {
  if (logLevel<LVL_DEBUG) return;
  kdDebug() << QTime::currentTime().toString()
            << " -<" << categoryText()
            << " "   << className << " (destruct)" << endl;
}

void LogService::log(int level, int category, QString text) {

  if (  logLevel < level)               return;
  if ( (logCategories & category) == 0) return;

  QString message = QTime::currentTime().toString()
                  + " " + levelText(level)
                  + " " + categoryText(category)
                  + " " + text;

  switch (level) {
    case LVL_FATAL:
    case LVL_ERROR: kdError()   << message << endl;break;
    case LVL_WARN:  kdWarning() << message << endl;break;
    default:        kdDebug()   << message << endl;break;

  }

  if (level==LVL_FATAL) kdError() << endl;
}

void LogService::logInfo ( int category, QString text ) {
  log(LVL_INFO,category,text);
}

void LogService::logWarn ( int category, QString text ) {
  log(LVL_WARN,category,text);
}

void LogService::logError( int category, QString text ) {
  log(LVL_ERROR,category,text);
}

void LogService::setLogLevel( int level ) {
  logLevel = level;
  LogService::doLogConstruct = (level >= LVL_DEBUG);
  LogService::doLogCall      = (level >= LVL_DEBUG);
  LogService::doLogInfo      = (level >= LVL_INFO);
}

void LogService::setLogCategoryFlag( int flag ) {
  logCategories = flag;
}

