/***************************************************************************
                          kickpimcard.h  -  description
                             -------------------
    begin                : Don Okt 17 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert@speckels.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMCARD_H
#define KICKPIMCARD_H

#include <qwidget.h>
#include <qframe.h>
#include <qstringlist.h>

#include "kmulticontentwidget.h"

/**
  *@author Bert Speckels
  */

  
class QLabel;
class QPushButton;
class KEdit;
class KTextBrowser;
class QColor;
class KPContact;

/** KickPimCard displays a read only and compact contact card with the
 *  most important data of a selected person.
 *
 *  @short Displays a read only and compact contact card.
 */
class KickPimCard : public QFrame
{
  Q_OBJECT
public:

  enum {ADDRESS, PHONE, EMAIL, BIRTHDAY, CONTENT_MAX };

  KickPimCard(QWidget *parent=0, const char *name=0, WFlags f = 0);
  ~KickPimCard();

  void setContact(KPContact* contact);

  virtual void show();
  
/*
  void mailClick (const QString &name, const QString &address);
  void urlClick  (const QString &url);
*/  
  
public slots:
  void mailContentClicked ();
  void nameContentClicked ();
  void onContentChanged(const QString&);

protected:

  void setAddressContent  ( );
  void setEmailContent    ( );
  void setBirthdayContent ( );
  void setNameContent     ( );
  void setPhoneContent    ( );
  QString getAddressType(int type);

  void recalcSize();
  
protected:

  KPContact*            m_contact;

  QString               m_webpage;
  
  KMultiContentWidget*  m_content[CONTENT_MAX];
  QLabel*               m_button [CONTENT_MAX];
  KTextBrowser*         m_note;    
  KMultiContentWidget*  m_name;  
};

#endif
