/**************************************************************************
                          kmulticontentwidget.cpp  -  description
                             -------------------
    begin                : Mon Okt 28 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmulticontentwidget.h"
 
#include <qcursor.h>
#include <qapplication.h>
#include <qclipboard.h>
 
#include <kpopupmenu.h>
#include <klocale.h>

KMultiContentWidget::KMultiContentWidget(QWidget *parent, const char *name ) : QLabel(parent,name)
{
  m_current="";
  m_oldLabelTitle="";
  m_labelWidget=0;
}

KMultiContentWidget::~KMultiContentWidget()
{
}

QString& KMultiContentWidget::getContent(QString name)
{
  return m_content[name];
}

void KMultiContentWidget::clearContent()
{
  m_content.clear();
  m_current="";
  if (m_labelWidget) m_labelWidget->setText(m_oldLabelTitle);
  else               m_oldLabelTitle="";
  setText("");
}

void KMultiContentWidget::addContent(QString name, QString content, bool set)
{
  m_content[ name ] = content;
  if (set)
  {
    m_current = name;
    setText( content );
  }
}


void KMultiContentWidget::selectContent (QString name)
{
  m_current = name;  
  setText( m_content[name] );
  if (m_labelWidget) m_labelWidget->setText(name); 
}

void KMultiContentWidget::setLabelWidget(QLabel* label)
{
  if (label) m_oldLabelTitle = label->text();
  m_labelWidget = label;
  if (m_labelWidget) m_labelWidget->setText("");
}

void KMultiContentWidget::mousePressEvent(QMouseEvent* event)
{  
  if (event->button() == LeftButton)
  {
    emit mouseButtonClicked();
  }
  else
  {
    KPopupMenu popup(this);
    popup.insertItem( i18n("&To Clipboard"), 0 );

    if (m_content.size()>1) 
    {
      popup.insertSeparator();

      int counter = 1;
      map<QString,QString>::iterator itor = m_content.begin();
      while (itor != m_content.end())
      {
        popup.insertItem(itor->first,counter);
        ++counter,++itor;
      }
    }
    int selection = popup.exec(QCursor::pos());

    if (selection==0) // copy to clipboard
    {                     
      QClipboard *cb = QApplication::clipboard();      
      cb->setText( text() );
    }
    else // changed displayed text
    {
      int counter = 1;
      map<QString,QString>::iterator itor = m_content.begin();
      while (itor != m_content.end())
      {
        if (counter==selection)
        {
          selectContent(itor->first);
          emit contentChanged(m_current);
          return;
        }
        ++counter,++itor;
      }
    }    
  }
}
