/***************************************************************************
                          kpcontactlistview.cpp  -  description
                             -------------------
    begin                : Die Jan 21 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qcolor.h>
#include <qheader.h>
#include <qscrollbar.h>
#include <klocale.h>

#include "kickpim.h"
#include "kpcontact.h"

#include "kickpimcontactview.h"
#include "kickpimcontactviewitem.h"

// #define STRESS_TEST

const QString KickPimContactView::CAT_REST      = I18N_NOOP("[Without Categories]");
const QString KickPimContactView::CAT_DISTLISTS = I18N_NOOP("[Distribution Lists]");
const QString KickPimContactView::CAT_ALL       = I18N_NOOP("[All Contacts]");


KickPimContactView::KickPimContactView(QWidget *parent, const char *name ) : KListView(parent,name)
{
  if (LogService::doLogConstruct) LogService::construct("KickPimContactView");

  QString iconDir = KickPIM::rep()->dirOfIcons();
  m_pixmapBirthday    = new QPixmap(iconDir+"hi12-kickpim-birthday.png");
  m_pixmapAnniversary = new QPixmap(iconDir+"hi12-kickpim-anniversary.png");
  m_pixmapEvent       = new QPixmap(iconDir+"hi12-kickpim-event.png");
  QColor bgcolor = parent->paletteBackgroundColor();

  setPaletteBackgroundColor ( bgcolor );
  setFrameStyle             ( QFrame::NoFrame );
  setHScrollBarMode         ( QScrollView::AlwaysOff );

  setSelectionMode  ( QListView::Extended );
  setMultiSelection ( KickPIM::opt()->multipleSelection );

  addColumn("name");
  header()->hide();

  connect( this,  SIGNAL ( doubleClicked         (QListViewItem*) ),
           this,  SLOT   ( onContactsDoubleClick (QListViewItem*) ) );

  m_tips = new KPDynamicTip( viewport() );

  setAcceptDrops(TRUE);
}

KickPimContactView::~KickPimContactView()
{
  if (LogService::doLogConstruct) LogService::destruct("KickPimContactView");
  delete m_tips;m_tips=0;
}

void KickPimContactView::updateContactList()
{
  if (LogService::doLogCall) LogService::call("KickPimContactView","updateContactList");
  clear();

  // insert contacts
  QString cat = KickPIM::opt()->contactCategory;

  if (cat==i18n(CAT_DISTLISTS))
  {
    QPtrList<DistributionList> list = KickPIM::rep()->distributionLists();
    DistributionList* dist = list.first();
    while (dist)
    {
       addDistributionList(dist);
       dist = list.next();
    }
  }
  else {
    KPContactList list = KickPIM::rep()->contacts();
    KPContact* contact = list.first();
    while (contact) {
      if ( cat.length() == 0 ||
           cat == i18n(CAT_ALL) ||
          (contact->categories().isEmpty() && cat == i18n(CAT_REST)) ||
          contact->categories().contains(cat) )
      {
        addContact(contact);
      }
      // stress test
      #ifdef STRESS_TEST
        for (int i=0;i<100;i++) addContact(contact);
      #endif

      contact = list.next();
    }
  }

  // sort contacts

  setSorting(0);
  sort();
  setSorting(-1);
};

void KickPimContactView::onContactsDoubleClick(QListViewItem* qitem)
{
  if (!qitem || !dynamic_cast<KickPimContactViewItem*>(qitem)) return;

  KickPimContactViewItem* item = static_cast<KickPimContactViewItem*>(qitem);

  emit contactDoubleClicked(item);  
}


void KickPimContactView::addContact(KPContact* contact)
{
  // add to the top of the list
  KickPimContactViewItem* item = 0;
  item = new KickPimContactViewItem( this, 0, KickPIM::rep()->displayName(contact) );
  item->setContact(contact);
};

void KickPimContactView::addDistributionList(DistributionList* distList)
{
  // append to the end of the list
  KickPimContactViewItem* item = 0;
  item = new KickPimContactViewItem( this, lastItem(), "["+distList->name()+"]" );
  item->setDistributionList(distList);
};

int KickPimContactView::preferredHeight()
{
  updateGeometry();
  show();
  return contentsHeight();
}



void KickPimContactView::dragEnterEvent(QDragEnterEvent* event)
{
  if (LogService::doLogCall) LogService::call( "KickPimContactView","dragEnterEvent");
  event->accept(true);
}


void KickPimContactView::dropEvent(QDropEvent* event)
{
  KickPimContactViewItem* item = (KickPimContactViewItem*)this->itemAt(event->pos());
  if (item!=0) {
    QString contactName = item->contact()->name();
    if (LogService::doLogInfo) LogService::logInfo( LogService::CAT_CONTACTS,"DropEvent on contact '"+contactName+"'");
  }
}

