/***************************************************************************
                          KickPimContactViewItem.cpp  -  description
                             -------------------
    begin                : Die Okt 22 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert@speckels.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kickpimcontactviewitem.h"

#include "kpcontact.h"

KickPimContactViewItem::KickPimContactViewItem( QListView* parent, QListViewItem* after, QString label )
    : QListViewItem(parent,after,label)
{
  m_contact  = 0;
  m_distList = 0;
}

KickPimContactViewItem::~KickPimContactViewItem()
{
  m_contact  = 0;
  m_distList = 0;
}

void KickPimContactViewItem::setContact(KPContact* contact)
{
  m_contact  = contact;
  m_distList = 0;
}

void KickPimContactViewItem::setDistributionList(DistributionList* list)
{
  m_distList = list;
}

KPContact* KickPimContactViewItem::contact()
{
  return m_contact;
}

DistributionList* KickPimContactViewItem::distributionList()
{
  return m_distList;
}

bool KickPimContactViewItem::isDistributionList()
{
  return m_distList!=0;
}



