/***************************************************************************
                          kickpimrepository.h  -  description
                             -------------------
    begin                : Mon Jan 13 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMREPOSITORY_H
#define KICKPIMREPOSITORY_H

#include <qptrlist.h>

#include <kabc/addressee.h>
#include <kabc/addressbook.h>
#include <kabc/stdaddressbook.h>
#include <kabc/distributionlist.h>

#include "kpevent.h"
#include "kpcontact.h"

#include "mailing/kickpimmailmonitor.h"

#include "kickpimoptions.h"

using namespace std;
using namespace KABC;

class KPEventReader;
class KPContactReader;

/** KickPimRepository manages all data of KickPIM which should be persistent
  * while the application is running.
  *
  * - a list of contacts
  * - a list of events
  * - options
  * - and more
  *
  * The repository also handles various global signals.
  *
  * @short Manages persistent data and handles various global signals.
  * @author Bert Speckels
  */
class KickPimRepository : public QObject
{
  
  Q_OBJECT
  
public: 
           KickPimRepository(QObject* owner);
  virtual ~KickPimRepository();

  /** Getting contacts and event. Has to be called externally */
  void     initData();

  void     mailMonitors_SetAutoCheck( bool on );
  void     mailMonitors_Check();

  KickPimMailMonitorThread*  mailMonitors_CreateThread ( KPMailAccount* account );
  void                       mailMonitors_FinishThread  ( KPMailAccount* account );

  void     reload();

  QString  yearSign();
  
  // lists
  KPContactList&              contacts()             { return m_contacts; };
  QStringList&                contactCategories();
  KPEventList&                events()               { return m_events; }
  QPtrList<DistributionList>& distributionLists()    { return m_distLists; };
  KPMailMonitorThreadList&    mailMonitorThreads()   { return m_mailMonitorThreads; };

  // options
  KickPimOptions* options();

  // tools
  int distanceToDate  ( QDate date, bool ignoreYear );
  int dateIsNear      ( QDate date, bool ignoreYear, int future, int past );
  QString displayName ( KPContact* entry );
  int compareEventDate( KPEvent* event1, KPEvent* event2 );

  // directories
  QString& dirOfIcons();
  QString& dirOfInfo();

  // contacts and events
  bool addContact();

  /** Checks all events but birthdays and anniversaries if they happened
   *  - m_options.remindEventsPast in the past (limited by m_options.lastReminded) or
   *  - m_options.remindEventsFuture in the future
   *  Returns the number of events.
   */
  int getWaitingEvents ( KPEventList& list );

  /** Checks all birthdays and anniversaries if they happened
   *  - m_options.remindAnniPast in the past (limited by m_options.lastReminded) or
   *  - m_options.remindAnniFuture in the future
   *  Returns the number of events.
   */
  int getWaitingAnniversaries ( KPEventList& list );

  /** Handles incoming events from other threads like mail monitors.
   *
   */
  virtual bool event(QEvent* event);

  void emergencySave();

signals:

  void contactListChanged   ( );
  void eventListChanged     ( );
  void emailAccountsChanged ( );
  void emailsChanged        ( );

public slots:

  void onEmailAcountsChanged ( );

protected slots:

  // void onContactsChanged     ( );
  void onContactListChanged  ( KPContactReader* );
  void onEventListChanged    ( KPEventReader*   );  

protected:

  void createMailMonitorThreads();
  void finishMailMonitorThreads();

  void clearContacts         ( );
  void clearEvents           ( );  

  void readContacts          ( );
  void readDistributionLists ( );
  void readContactEvents     ( );
  void readEvents            ( );
 
protected:

  // options
  KickPimOptions*             m_options;  

  // events
  KPEventReader*              m_eventReader;
  KPEventReader*              m_contactEventReader;
  KPEventList                 m_events;

  // contacts
  KPContactReader*            m_contactReader;
  KPContactList               m_contacts;
  QPtrList<DistributionList>  m_distLists;

  // mail
  // KPMailMonitorList           m_mailMonitors;
  KPMailMonitorThreadList     m_mailMonitorThreads;

  // directories
  QString                     m_dirIcons;
  QString                     m_dirInfo;

  // other
  QString                     m_yearSign;

  
};

#endif
