/***************************************************************************
                          KickPimWidget.h  -  description
                             -------------------
    begin                : Fre Okt 18 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert@speckels.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMWIDGET_H
#define KICKPIMWIDGET_H

#include <qframe.h>
#include <qdatetime.h>

#include "kickpimiface.h"

// #define USE_DCOP

class QPixmap;
class QTimer;
class QToolTip;
class QWidget;
class KPopupMenu;
class KickPimMenu;
class QDragEnterEvent;
class QDragLeaveEvent;

/** The KickPimWidget renders the kicker applet icon and displays
 *  all the different states of KickPIM. It also handles a users action
 *  on that icon.
 *
 *  Displayed states are:
 *  - near birthdays, emails, events (showing sub icons)
 *  - notifications (blinking sub icons)
 *
 *  Actions are:
 *  - Clicking the left mouse button displays the KickPimMenu
 *  - Clicking the right mouse button displays a menu with various options
 *    like settings and mail checking.
 *  - Shortkey actions to display, hide or toggle the KickPimMenu and more.
 *
 * @short Renders the kicker applet icon and handles user actions.
 *
 * @author Bert Speckels
 */
class KickPimWidget : public QFrame
                             , virtual public KickPimIface
{
  Q_OBJECT
   
public:
  KickPimWidget(QWidget *parent=0, const char *name=0);
  ~KickPimWidget();  

  void init();

  bool setMenuVisible(bool visible);
  void displayMenu(bool displayAtCenter=false);
  void displayPopupMisc();
  void displayAboutDialog();
  
public slots:

  //virtual bool  process(const QCString &fun, const QByteArray &data, QCString &replyType, QByteArray &replyData);
  virtual ASYNC showMenu();
  virtual ASYNC hideMenu();
  virtual ASYNC toggleMenu();
  virtual ASYNC showEvents();

  virtual void addContact();
  virtual void checkMailAccounts();
  virtual bool toggleMailCheck();

  void resetState();
  
  void popupMiscClick(int id);
  void mousePressEvent(QMouseEvent *e);

  void onTimerBlink();  
  void onTimerCheckEvents();

protected:

  // virtual void keyPressEvent(QKeyEvent* e);
  virtual void paintEvent(QPaintEvent* event);
  virtual void dragEnterEvent(QDragEnterEvent* event);
  virtual void dragLeaveEvent(QDragLeaveEvent* event);

  void drawDefault       ( QPainter* painter );
  void drawEmails        ( QPainter* painter, bool vip );
  void drawEvents        ( QPainter* painter, int  priority );
  void drawAnniversaries ( QPainter* painter );

  void drawText     ( QPainter* painter, QString  text  );
  void drawIcon     ( QPainter* painter, QPixmap* icon );

  void blink(bool active);

  /** show configuration dialog */
  void savePreferences();

  void prefsContacts();
  void prefsEmailAccounts();
  void prefsGeneral();
  
  void displayKeyPreferences();

  void updateWidget();  

protected slots:

  void onEventsChanged();
  void onEmailsChanged();
  void onNotifyWidgetDestroyed();
  
protected:

//#ifdef USE_DCOP
  DCOPClient*    m_dcopClient;
  QString        m_dcopId;
//#endif

  // Counters
  int      m_eventCount;
  int      m_anniCount;
  int      m_emailCount;

  // Blinking
  bool     m_blinkToggle;

  bool     m_blinkEvent;
  bool     m_blinkAnni;
  bool     m_blinkEmail;
  bool     m_blinkEmailVip;

  // Timer
  QTimer*  m_emailTimer;
  QTimer*  m_eventTimer;
  QTimer*  m_blinkTimer;

  // Icons
  QPixmap* m_icon;
  QPixmap* m_iconEmail;
  QPixmap* m_iconEmailVip;
  QPixmap* m_iconEvent;
  QPixmap* m_iconAnni;

  // Menues
  KickPimMenu*  m_menu;
  KPopupMenu*   m_popupMisc;
  
  // other Widgets
  QToolTip*     m_toolTip;
  QWidget*      m_notifyWidget;

};

#endif
