/***************************************************************************
                          kpcontacteventreader.cpp  -  description
                             -------------------
    begin                : Sam Jan 18 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
 
#include "kickpim.h"
#include "kickpimrepository.h"
#include "kpcontact.h"
#include "kpcontactevent.h"
 
#include "kpcontacteventreader.h"

using namespace std;

KPContactEventReader::KPContactEventReader()
{
  m_currentContact   = 0;
  m_currentEventType = 0;
  /*
  connect( m_addrBook, SIGNAL( addressBookChanged(AddressBook*) ),
           this,       SLOT  ( onAddressBookChanged(AddressBook*) ) );
  */
}

KPContactEventReader::~KPContactEventReader()
{
}

KPEvent* KPContactEventReader::first()
{
  m_currentContact   = 0;
  m_currentEventType = 0;

  KPEvent* event = getNextEvent();
  return event;
}

KPEvent* KPContactEventReader::next()
{
  KPEvent* event = getNextEvent();
  return event;
}

KPEvent* KPContactEventReader::getNextEvent()
{
  if (!KickPIM::rep()) return 0;
  
  KPEvent*   event = 0;
  KPContact* contact = 0;

  QDate date;
  
  contact = KickPIM::rep()->contacts().at(m_currentContact);

  while (!event && contact)
  {
    switch (m_currentEventType)
    {
      case 0: // birthday
        date = contact->birthday();
        if( date.isValid() )
        {
          event = new KPContactEvent();
          event->setDate    ( date );
          event->setContact ( contact );
          event->setType    ( KPContactEvent::BIRTHDAY );          
          event->setText    ( KickPIM::rep()->displayName(contact) );          
        }
        m_currentEventType++;
        break;

      case 1: // anniversary
        date = contact->anniversary();
        if( date.isValid() )
        {
          event = new KPContactEvent();
          event->setDate    ( date );
          event->setContact ( contact );
          event->setType    ( KPContactEvent::ANNIVERSARY );          
          event->setText    ( KickPIM::rep()->displayName(contact) );          
        }
        m_currentEventType++;
        break;

      default:
        contact = KickPIM::rep()->contacts().at(++m_currentContact);
        m_currentEventType=0;
        break;
    }
  }

  return event;
}

