/***************************************************************************
                          kpkabcontact.h  -  description
                             -------------------
    begin                : Fre Jan 17 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPKABCONTACT_H
#define KPKABCONTACT_H

#include <kabc/addressee.h>
#include <kabc/addressbook.h>

#include "kpcontact.h"


using namespace KABC;


class KProcess;

/**
  *@author Bert Speckels
  */

class KPKabContact : public KPContact
{

  Q_OBJECT
  
public:

  KPKabContact(bool autoInsert=false);
  
  // aspecially for this class:
  KPKabContact(Addressee& addr);

  virtual ~KPKabContact();

  virtual bool isEmpty() const;

  virtual void changed();
    
  //
  // GET
  //
  
  virtual QStringMap  names()          const;
  virtual QAddressMap addresses()      const;
  virtual QStringList emailAddresses() const;
  virtual QStringMap  phoneNumbers()   const;
  virtual QStringMap  webpageURLs()    const;
  virtual QStringList categories()     const;
  virtual QDate       birthday()       const;
  virtual QDate       anniversary()    const;
  virtual QString     note()           const;

  //
  // SET
  //

  virtual void setName(QString name, QString key);  
  virtual bool setNote (QString& note);

  virtual void clearEmailAddresses();
  virtual void addEmailAddress(QString emailAddr, bool preferred = false);

  virtual void clearPhoneNumbers();
  virtual void addPhoneNumber(QString number, QString key);

  virtual void setBirthday    ( QDate date );
  virtual void setAnniversary ( QDate date );

  virtual void setCategories ( QStringList list );

  virtual bool        edit();
  virtual bool        remove();
  
protected:

  Addressee* m_addr;
  bool       m_toBeInserted;

};

#endif
