/***************************************************************************
                          KickPimMail.h  -  description
                             -------------------
    begin                : Fre Jan 17 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMMAIL_H
#define KICKPIMMAIL_H


#include <krun.h>

#include <qdatetime.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qobject.h>

/**
  *@author Bert Speckels
  */

class KickPimMail : public QObject
{

  Q_OBJECT

public:

  KickPimMail();
  virtual ~KickPimMail();

  virtual bool isEmpty() const = 0;

  virtual QString   subject()      const = 0;
  virtual QString   sender()       const = 0;
  virtual QDateTime dateAndTime()  const = 0;
  virtual int       sizeInBytes()  const = 0;
};


class KickPimMailList : public QPtrList<KickPimMail>
{
public:

  enum TCompareMode { SENDER, SUBJECT, DATE, SIZE };

  KickPimMailList();
  virtual ~KickPimMailList();

  virtual int compareItems(QPtrCollection::Item item1,QPtrCollection::Item item2);
};



#endif
