/***************************************************************************
                          kickpimmaildialog.cpp  -  description
                             -------------------
    begin                : Mit M? 5 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistbox.h>
#include <klistbox.h>

#include "kickpimmaildialog.h"

#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <kpopupmenu.h>
#include <kmessagebox.h>
#include "kpmailaccount.h"
#include "kpmailpop3dialog.h"
#include "kpmailimapdialog.h"
#include "kpmailmboxdialog.h"
//#include "kpmailfiledialog.h"

#include "../kickpim.h"

class KPAccountListBoxItem : public QListBoxText
{
public:
  KPAccountListBoxItem(QListBox* list, KickPimMailMonitorThread* thread);
  ~KPAccountListBoxItem();

  KickPimMailMonitorThread* thread() { return m_thread; }

  virtual QString text() const {
    return m_thread->monitor()->account()->name();
  };

protected:

  KickPimMailMonitorThread* m_thread;

};

KPAccountListBoxItem::KPAccountListBoxItem(QListBox* list, KickPimMailMonitorThread* thread)
                     : QListBoxText(list, thread->monitor()->account()->name())
{
  m_thread = thread;
}

KPAccountListBoxItem::~KPAccountListBoxItem()
{
  m_thread=0;
}

/************************************************
 *
 *
 *
 ************************************************/

KickPimMailDialog::KickPimMailDialog(QWidget *parent, const char *name ) : KickPimMailDlg(parent,name)
{
  connect((QObject*)OkButton,SIGNAL(pressed()),this,SLOT(accept()));

  connect((QObject*)AddAccount,SIGNAL(pressed()),this,SLOT(onAddAccount()));
  connect((QObject*)EditAccount,SIGNAL(pressed()),this,SLOT(onEditAccount()));
  connect((QObject*)DeleteAccount,SIGNAL(pressed()),this,SLOT(onDeleteAccount()));
  connect((QObject*)AccountList,SIGNAL(doubleClicked(QListBoxItem*)),this,SLOT(doubleClick(QListBoxItem*)));

  QString appPath   = KickPIM::opt()->mailNotifyAppPath;
  QString soundFile = KickPIM::opt()->mailNotifySoundFile;
  bool beep  = KickPIM::opt()->mailNotifyBeep;
  bool popup = KickPIM::opt()->mailNotifyPopup;

  DisplayPopupNotify->setChecked( popup );

  SoundNotifyBeep -> setChecked(beep);
  SoundNotifyFile -> setChecked(soundFile.length()>0 );
  AppNotify       -> setChecked( appPath.length()>0 );

  SoundNotifyFileValue -> setURL( soundFile );
  AppNotifyValue       -> setURL( appPath );

  KPMailMonitorThreadList&  list = KickPIM::rep()->mailMonitorThreads();
  QPtrListIterator<KickPimMailMonitorThread> itor( list );
  KickPimMailMonitorThread* thread = 0;

  // pause running threads and add a listbox item for each!
  LogService::logInfo(LogService::CAT_MAIL,"Pause mail monitors");
  while ( itor.current()!=0 ) {
    thread = (KickPimMailMonitorThread*)itor.current();
    LogService::logInfo(LogService::CAT_MAIL,"- monitor '"+thread->monitor()->account()->name()+"'");
    thread->setSkipMailchecks( true );
    new KPAccountListBoxItem(AccountList,thread);
    ++itor;
  }
}

KickPimMailDialog::~KickPimMailDialog()
{
}

void KickPimMailDialog::accept()
{
  KickPIM::opt()->mailNotifyPopup = DisplayPopupNotify->isChecked();
  KickPIM::opt()->mailNotifyBeep  = SoundNotifyBeep->isChecked();

  if (SoundNotifyFile->isChecked()) {
    KickPIM::opt()->mailNotifySoundFile = SoundNotifyFileValue->url();
  }
  else {
    KickPIM::opt()->mailNotifySoundFile = "";
  }
  if (AppNotify->isChecked()) {
    KickPIM::opt()->mailNotifyAppPath = AppNotifyValue->url();
  }
  else {
    KickPIM::opt()->mailNotifyAppPath = "";
  }

  KickPIM::opt()->save();

  // unpause all threads
  KPMailMonitorThreadList&  list = KickPIM::rep()->mailMonitorThreads();
  QPtrListIterator<KickPimMailMonitorThread> itor( list );
  KickPimMailMonitorThread* thread = 0;

  LogService::logInfo(LogService::CAT_MAIL,"Unpause mail monitors");
  while ( itor.current()!=0 ) {
    thread = (KickPimMailMonitorThread*)itor.current();
    LogService::logInfo(LogService::CAT_MAIL,"- monitor '"+thread->monitor()->account()->name()+"'");
    thread->setSkipMailchecks( false );
    ++itor;
  }
  QDialog::accept();
}


void KickPimMailDialog::onAddAccount()
{
  KPopupMenu* popup = new KPopupMenu(this,"RightClickPopupMisc");
  popup->insertItem ( i18n("POP3"),0,0 );
  popup->insertItem ( i18n("IMAP"),1,1 );
  popup->insertItem ( i18n("Mbox"),2,2 );
  // popup->insertItem ( i18n("Local"),3,3 );
  int result = popup->exec( AddAccount->mapToGlobal( QPoint(0,AddAccount->height()) ),0);
  KPMailAccount* account = 0;
  switch (result) {
    case 0: // POP3
      account = addAccount_POP3();
      break;
    case 1: // IMAP
      account = addAccount_IMAP();
      break;
    case 2: // Mbox
      account = addAccount_Mbox();
      break;
    case 3: // Local
      account = addAccount_File();
      break;
  }
  if (account!=0) {
    addAccount(account);
  }
}

KPMailAccount* KickPimMailDialog::addAccount_POP3()
{
  KPMailPop3Dialog dlg;
  KPMailAccount* account = new KPMailAccount();
  dlg.setAccountData(account);
  LogService::logInfo(LogService::CAT_MAIL,"Adding a new POP3 account ...");
  if ( dlg.exec() == QDialog::Accepted ) {
    dlg.updateAccount(account);
  }
  else { delete account;account=0; }
  return account;
}

KPMailAccount* KickPimMailDialog::addAccount_IMAP()
{
  KPMailImapDialog dlg;
  KPMailAccount* account = new KPMailAccount();
  // set default INBOX
  KPMailURL url;url.setPath( "/INBOX" );
  account->setUrl( url );
  dlg.setAccountData(account);
  LogService::logInfo(LogService::CAT_MAIL,"Adding a new IMAP account ...");
  if ( dlg.exec() == QDialog::Accepted ) {
    dlg.updateAccount(account);
  }
  else { delete account;account=0; }
  return account;
}

KPMailAccount* KickPimMailDialog::addAccount_File()
{
  KPMailMboxDialog dlg;
  KPMailAccount* account = new KPMailAccount();
  // set default INBOX
  KPMailURL url;url.setPath( "/var/mail/your-user-name" );
  account->setUrl( url );
  dlg.setAccountData(account);
  LogService::logInfo(LogService::CAT_MAIL,"Adding a new Local (File) account ...");
  if ( dlg.exec() == QDialog::Accepted ) {
    dlg.updateAccount(account);
  }
  else { delete account;account=0; }
  return account;
}

KPMailAccount* KickPimMailDialog::addAccount_Mbox()
{
  KPMailMboxDialog dlg;
  KPMailAccount* account = new KPMailAccount();
  // set default INBOX
  KPMailURL url;url.setPath( "/var/mail/your-user-name" );
  account->setUrl( url );
  dlg.setAccountData(account);
  LogService::logInfo(LogService::CAT_MAIL,"Adding a new Mbox account ...");
  if ( dlg.exec() == QDialog::Accepted ) {
    dlg.updateAccount(account);
  }
  else { delete account;account=0; }
  return account;
}

void KickPimMailDialog::addAccount( KPMailAccount* account )
{
  // find a unique name
  int count = 1;
  KPAccountListBoxItem* item = 0;
  QString newName = account->name();
  do  {
    item = (KPAccountListBoxItem*)AccountList->findItem(newName);
    if (item!=0) newName = account->name() + "-" + QString::number(count);
    count++;
  } while (item!=0);
  if ( newName != account->name() ) {
    KMessageBox::information(0,
                        i18n("There is already an account named '%1'.\n\n").arg(account->name())
                      + i18n("I renamed the new account to '%1'.").arg(newName),
                        i18n("account renamed"),
                        "KickPimMailDialog.RenameInfo"
                      );
  }
  account->setName( newName ); // set the unique name
  LogService::logInfo(LogService::CAT_MAIL,"Added account '"+newName+"' to the list ...");
  KickPIM::opt()->mailAccounts.append(account);
  KickPimMailMonitorThread* thread = KickPIM::rep()->mailMonitors_CreateThread( account );
  thread->setSkipMailchecks( true );
  item = new KPAccountListBoxItem(AccountList,thread);
  KickPIM::rep()->onEmailAcountsChanged();
}



void KickPimMailDialog::onDeleteAccount()
{
  DeleteAccount->setOn(false);
  KPAccountListBoxItem* item = (KPAccountListBoxItem*)AccountList->selectedItem();
  if (item==0) return;

  int result = KMessageBox::questionYesNo(
                        0,
                        i18n("Do you really want to remove the account(s)?"),
                        i18n("Remove Accounts"),
                        KStdGuiItem::ok(), KStdGuiItem::no());
  if (result==KMessageBox::Yes) {
    KPMailAccount* acc = item->thread()->monitor()->account();
    KickPIM::rep()->mailMonitors_FinishThread( acc );
    KickPIM::opt()->mailAccounts.remove( acc );
    delete item;item=0;
    KickPIM::rep()->onEmailAcountsChanged();
  }
}

void KickPimMailDialog::onEditAccount()
{
  EditAccount->setOn(false);
  KPAccountListBoxItem* selItem = (KPAccountListBoxItem*)AccountList->selectedItem();
  if (selItem!=0) editItem(selItem);
}


void KickPimMailDialog::doubleClick(QListBoxItem* item) {
  if (item!=0) editItem((KPAccountListBoxItem*)item);
}

void KickPimMailDialog::editItem(KPAccountListBoxItem* item) {
  KPMailAccount* account = item->thread()->monitor()->account();

  QString protocol = account->url().protocol();
  if (protocol=="pop3") {
    KPMailPop3Dialog dlg;
    dlg.setAccountData(account);
    if (dlg.exec() == QDialog::Accepted) {
      dlg.updateAccount(account);
      KickPIM::rep()->onEmailAcountsChanged();
    }
  }
  else if (protocol=="imap4") {
    KPMailImapDialog dlg;
    dlg.setAccountData(account);
    if (dlg.exec() == QDialog::Accepted) {
      dlg.updateAccount(account);
      KickPIM::rep()->onEmailAcountsChanged();
    }
  }
  else if (protocol="file") {
    KPMailMboxDialog dlg;
    dlg.setAccountData(account);
    if (dlg.exec() == QDialog::Accepted) {
      dlg.updateAccount(account);
      KickPIM::rep()->onEmailAcountsChanged();
    }
  }
  else if (protocol="mbox") {
    KPMailMboxDialog dlg;
    dlg.setAccountData(account);
    if (dlg.exec() == QDialog::Accepted) {
      dlg.updateAccount(account);
      KickPIM::rep()->onEmailAcountsChanged();
    }
  }
}

