/***************************************************************************
                          kickpimmaildialog.h  -  description
                             -------------------
    begin                : Mit M? 5 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMMAILDIALOG_H
#define KICKPIMMAILDIALOG_H

#include <qwidget.h>

#include "kickpimmaildlg.h"

class KPAccountListBoxItem;
class KPMailAccount;

/**
  *@author Bert Speckels
  */

class KickPimMailDialog : public KickPimMailDlg
{
   Q_OBJECT
public: 
  KickPimMailDialog(QWidget *parent=0, const char *name=0);
  ~KickPimMailDialog();

public slots:

  void accept();  
  void onAddAccount();
  void onDeleteAccount();
  void onEditAccount();
  void doubleClick(QListBoxItem* item);

private:
  KPMailAccount* addAccount_POP3();
  KPMailAccount* addAccount_IMAP();
  KPMailAccount* addAccount_Mbox();
  KPMailAccount* addAccount_File();
  void addAccount ( KPMailAccount* account );
  void editItem   ( KPAccountListBoxItem* item );
  void checkAndCorrectAccount(KPMailAccount* account);  
};

#endif
