/***************************************************************************
                          kpmailMboxDialog.cpp  -  description
                             -------------------
    begin                : Mit Mr 5 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <klineedit.h>
#include <kpassdlg.h>
#include <kmessagebox.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kurlrequester.h>
#include "../LogService.h"

#include "kpmailaccount.h"

#include "kpmailmboxdialog.h"



KPMailMboxDialog::KPMailMboxDialog(QWidget *parent, const char *name ) : KPMailMboxDlg(parent,name)
{
  connect((QObject*)OkButton,SIGNAL(pressed()),this,SLOT(accept()));
  connect((QObject*)CancelButton,SIGNAL(pressed()),this,SLOT(reject()));
}

KPMailMboxDialog::~KPMailMboxDialog()
{
}


void KPMailMboxDialog::setAccountData(KPMailAccount* account)
{
  m_account = account;
  if (m_account!=0) {
    AccountName->setText(m_account->name());
    Directory->setURL( m_account->url().path() );
    int index = m_account->isActive() ? 0 : 1;
    AccountState->setCurrentItem( index );
    int pollIval = m_account->pollInterval();
    AutoCheck->setChecked( pollIval>=0 );
    onAutoCheckToggled( pollIval>=0 );

    if (pollIval<0) pollIval = 5 * 60; // 5 minutes by default
    CheckMinutes->setValue( pollIval/60 );
    CheckSeconds->setValue( (int)(pollIval%60) );
  }
}


void KPMailMboxDialog::updateAccount( KPMailAccount* account )
{
  KPMailURL url;
  url.setProtocol( "mbox" );
  url.setPath( Directory->url() );

  int index = AccountState->currentItem();
  account->setActive( index==0 );
  account->setName( AccountName->text( ) );
  account->setUrl(url);
  int pollIval = -1;
  if (AutoCheck->isChecked()) {
    pollIval= CheckMinutes->value() * 60 + CheckSeconds->value();
  }
  account->setPollInterval( pollIval );
  LogService::logInfo( LogService::CAT_MAIL, "KPMailMboxDialog: New or updated account: "
                                             +url.prettyURL());
}

void KPMailMboxDialog::accept()
{
  // check the account name
  QString name = AccountName->text();
  name = name.stripWhiteSpace();
  if (name.length()==0) {
    KMessageBox::information(0, i18n("Please enter a name for this account!"),
                                i18n("Enter a name!") );
    return;
  }

  QDialog::accept();
}

