/*
 * KPMailURL.h

   This is taken from KBiff:
     Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
     Copyright (C) 1999 Bjorn Hansson <Bjorn.Hansson@signal.uu.se>

  -------------------------------------------------------------

   Copyright (C) 2000-2001 Dawit Alemayehu <adawit@kde.org>
   Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License (LGPL) as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   This KMD5 class is based on a C++ implementation of
   "RSA Data Security, Inc. MD5 Message-Digest Algorithm" by
   Mordechai T. Abzug,	Copyright (c) 1995.  This implementation
   passes the test-suite as defined by RFC 1321.

   RFC 1321 "MD5 Message-Digest Algorithm" Copyright (C) 1991-1992.
   RSA Data Security, Inc. Created 1991. All rights reserved.

   The encoding and decoding utilities in KCodecs with the exception of
   quoted-printable were ported from the HTTPClient java package by Ronald
   Tschalr Copyright (C) 1996-1999. The quoted-printable codec as described
   in RFC 2045, section 6.7. is by Rik Hemsley (C) 2001.

 */
#ifndef KPMailURL_H
#define KPMailURL_H

#include <kurl.h>

/**
 * This is a simple extension to the KURL class.
 */
class KPMailURL : public KURL
{
public:
	/**
	 * Default constructor
	 */
	KPMailURL();

	/**
	 * Construct a KPMailURL object from _url
	 */
	KPMailURL(const QString& _url);

	/**
	 * Returns the parameter value found in the search part of the URL
	 */
	QString searchPar( const QString & _parName ) const;

	/**
	 * Sets a parameter value in the search part of the URL
	 */
	void setSearchPar( const QString & _parName, const QString & _newParVal );

	QString pass() const;

private:
	/**
	 * Returns the position of a parameter within the search part
	 */
	int findPos( const QString & _searchPart, const QString & _parName ) const;
};
#endif // KBIFFURL_H
