#include "kj.h"

static GtkWidget *kj_configure_win = NULL, *kj_about_win = NULL;
static GtkWidget *config_opt_swp, *config_opt_spp, *config_opt_lpl,
	*config_opt_cxs, *config_opt_oxc;
static gint config_pleditor;
static GList *res_list = NULL;
extern k_resource res;
extern k_config config;
extern gint kj_running;

typedef struct
{
	gchar *name, *path;
} res_node;


/* ---------------------------------------------------------------------- */
void kj_default_config(void)
{
	memset(&config, 0, sizeof(k_config));
	config.res_name = g_strdup(KJSKIN);
	config.scope_mode = 1;
	config.refresh_rate = 1;
	config.freq_falloff = 3;
}


/* ---------------------------------------------------------------------- */
void kj_load_config(void)
{
ConfigFile *cfile;
gchar *fname;

	fname = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);

	if ((cfile = xmms_cfg_open_file(fname)))
		{
		xmms_cfg_read_string(cfile, "kjofol", "resource_name", &config.res_name);
		xmms_cfg_read_boolean(cfile, "kjofol", "save_window_pos", &config.save_win_pos);
		xmms_cfg_read_int(cfile, "kjofol", "window_x", &config.win_x);
		xmms_cfg_read_int(cfile, "kjofol", "window_y", &config.win_y);
		xmms_cfg_read_boolean(cfile, "kjofol", "save_plist_pos", &config.save_plist_pos);
		xmms_cfg_read_boolean(cfile, "kjofol", "lock_plist", &config.lock_plist);
		xmms_cfg_read_int(cfile, "kjofol", "plist_x", &config.plist_x);
		xmms_cfg_read_int(cfile, "kjofol", "plist_y", &config.plist_y);
		xmms_cfg_read_boolean(cfile, "kjofol", "close_main_startup", &config.close_main_startup);
		xmms_cfg_read_boolean(cfile, "kjofol", "quit_xmms_exit", &config.quit_xmms_exit);
		xmms_cfg_read_int(cfile, "kjofol", "playlist_editor_type", &config.playlist_editor_type);
		xmms_cfg_read_int(cfile, "kjofol", "vis_mode", &config.vis_mode);
		xmms_cfg_read_int(cfile, "kjofol", "analyser_mode", &config.analyser_mode);
		xmms_cfg_read_int(cfile, "kjofol", "analyser_type", &config.analyser_type);
		xmms_cfg_read_int(cfile, "kjofol", "analyser_peaks", &config.analyser_peaks);
		xmms_cfg_read_int(cfile, "kjofol", "scope_mode", &config.scope_mode);
		xmms_cfg_read_int(cfile, "kjofol", "refresh_rate", &config.refresh_rate);
		xmms_cfg_read_int(cfile, "kjofol", "freq_falloff", &config.freq_falloff);
		xmms_cfg_read_int(cfile, "kjofol", "peak_falloff", &config.peak_falloff);
		xmms_cfg_free(cfile);
		}
	g_free(fname);
}


/* ---------------------------------------------------------------------- */
void kj_save_config(void)
{
ConfigFile *cfile;
gchar *fname;

	fname = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	if(!(cfile = xmms_cfg_open_file(fname)))
		cfile = xmms_cfg_new();

	xmms_cfg_write_string(cfile, "kjofol", "resource_name", config.res_name);
	xmms_cfg_write_boolean(cfile, "kjofol", "save_window_pos", config.save_win_pos);
	xmms_cfg_write_int(cfile, "kjofol", "window_x", config.win_x);
	xmms_cfg_write_int(cfile, "kjofol", "window_y", config.win_y);
	xmms_cfg_write_boolean(cfile, "kjofol", "save_plist_pos", config.save_plist_pos);
	xmms_cfg_write_boolean(cfile, "kjofol", "lock_plist", config.lock_plist);
	xmms_cfg_write_int(cfile, "kjofol", "plist_x", config.plist_x);
	xmms_cfg_write_int(cfile, "kjofol", "plist_y", config.plist_y);
	xmms_cfg_write_boolean(cfile, "kjofol", "close_main_startup", config.close_main_startup);
	xmms_cfg_write_boolean(cfile, "kjofol", "quit_xmms_exit", config.quit_xmms_exit);
	xmms_cfg_write_int(cfile, "kjofol", "playlist_editor_type", config.playlist_editor_type);
	xmms_cfg_write_int(cfile, "kjofol", "vis_mode", config.vis_mode);
	xmms_cfg_write_int(cfile, "kjofol", "analyser_mode", config.analyser_mode);
	xmms_cfg_write_int(cfile, "kjofol", "analyser_type", config.analyser_type);
	xmms_cfg_write_int(cfile, "kjofol", "analyser_peaks", config.analyser_peaks);
	xmms_cfg_write_int(cfile, "kjofol", "scope_mode", config.scope_mode);
	xmms_cfg_write_int(cfile, "kjofol", "refresh_rate", config.refresh_rate);
	xmms_cfg_write_int(cfile, "kjofol", "freq_falloff", config.freq_falloff);
	xmms_cfg_write_int(cfile, "kjofol", "peak_falloff", config.peak_falloff);
	xmms_cfg_write_file(cfile, fname);
	xmms_cfg_free(cfile);
	g_free(fname);
}


/* ---------------------------------------------------------------------- */
static void add_resource(gchar *path)
{
gchar *tmp;
res_node *node = (res_node *)g_malloc(sizeof(res_node));

	node->path = path;
	tmp = strrchr(path, '/');
	if(!tmp) tmp = path;
	else tmp++;
	node->name = g_strdup(tmp);
	if((tmp = strrchr(node->name, '.'))) *tmp = '\0';
	res_list = g_list_prepend(res_list, node);
}


/* ---------------------------------------------------------------------- */
static void scan_resource_dir(char *path)
{
DIR *dir;
struct dirent *dirent;
struct stat statbuf;
char *file, *tmp;

	if((dir = opendir(path)))
		{
		while((dirent = readdir(dir)))
			{
			if(strcmp(dirent->d_name, ".") && strcmp(dirent->d_name, ".."))
				{
				file = (char *)g_malloc(dirent->d_reclen + strlen(path) + 2);
				sprintf(file, "%s/%s", path, dirent->d_name);
				if(!lstat(file, &statbuf))
					{
					if(S_ISDIR(statbuf.st_mode)) add_resource(file);
					else if(S_ISREG(statbuf.st_mode) || S_ISLNK(statbuf.st_mode))
						{
						tmp = strrchr(file, '.');
						if(tmp)
							{
							if(!strcasecmp(tmp, ".zip")) add_resource(file);
							else g_free(file);
							}
						else g_free(file);
						}
					else g_free(file);
					}
				else g_free(file);
				}
			}
		closedir(dir);
		}
}


/* ---------------------------------------------------------------------- */
static gint res_compare(gconstpointer a, gconstpointer b)
{
	return strcasecmp(((res_node *)a)->name, ((res_node *)b)->name);
}


/* ---------------------------------------------------------------------- */
static void res_free(gpointer data, gpointer user_data)
{
	g_free(((res_node *)data)->name);
	g_free(((res_node *)data)->path);
	g_free(data);
}


/* ---------------------------------------------------------------------- */
void cb_kj_configure_ok(void)
{
	config.save_win_pos = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_opt_swp));
	config.save_plist_pos = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_opt_spp));
	config.lock_plist = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_opt_lpl));
	config.close_main_startup = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_opt_cxs));
	config.quit_xmms_exit = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_opt_oxc));
	config.playlist_editor_type = config_pleditor;

	kj_save_config();
	gtk_widget_destroy(kj_configure_win);
}


/* ---------------------------------------------------------------------- */
void cb_change_res(GtkWidget * widget, gint row, gint column, GdkEventButton * event)
{
	if(config.res_name) g_free(config.res_name);
	config.res_name = g_strdup(((res_node *)g_list_nth(res_list, row)->data)->path);

	if(kj_running)
		{
		load_resource(config.res_name, NULL, &res);
		kj_set_resource();
		kj_set_pl();
		}
}


/* ---------------------------------------------------------------------- */
void cb_change_opt(GtkWidget *item, GtkPositionType pos)
{
	config_pleditor = pos;
}


/* ---------------------------------------------------------------------- */
void kj_configure_cleanup(void)
{
	if(kj_configure_win) gtk_widget_destroy(kj_configure_win);
}


/* ---------------------------------------------------------------------- */
void kj_configure(void)
{
gchar *str, *resource_titles[] = {"Resource File"};
GtkWidget *vbox, *notebook;
GtkWidget *nb_box, *nb_vbox, *res_frame, *res_clist, *res_swin, *opt_table;
GtkWidget *bbox, *ok, *cancel, *opt, *menu, *item;
GList *entry;
int i;

	if(!kj_configure_win)
		{
		if(res_list)
			{
			g_list_foreach(res_list, res_free, NULL);
			g_list_free(res_list);
			}
		res_list = NULL;

		str = g_strconcat(g_get_home_dir(), "/.xmms/kjofol", NULL);
		scan_resource_dir(str);
		g_free(str);
		str = g_strconcat(XMMS_DIR, "/kjofol", NULL);
		scan_resource_dir(str);
		g_free(str);

		res_list = g_list_sort(res_list, res_compare);

#if DIGIDECK
			/* digideck */
		str = g_strconcat(g_get_home_dir(), "/.xmms/digideck", NULL);
		scan_resource_dir(str);
		g_free(str);
#endif

			/* Create window */
		kj_configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(kj_configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &kj_configure_win);
		gtk_window_set_title(GTK_WINDOW(kj_configure_win), "KJ Interface Configuration");
		gtk_window_set_policy(GTK_WINDOW(kj_configure_win), FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(kj_configure_win), GTK_WIN_POS_CENTER);
		gtk_container_border_width(GTK_CONTAINER(kj_configure_win), 10);

			/* Notebook */
		vbox = gtk_vbox_new(FALSE, 10);
		gtk_container_add(GTK_CONTAINER(kj_configure_win), vbox);

		notebook = gtk_notebook_new();
		gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

			/*
			 * Options selection page
			 */
		nb_box = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(nb_box), 5);

		res_frame = gtk_frame_new("Options");
		gtk_box_pack_start(GTK_BOX(nb_box), res_frame, FALSE, FALSE, 0);

		nb_vbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(nb_vbox), 5);
		gtk_container_add(GTK_CONTAINER(res_frame), nb_vbox);

		opt_table = gtk_table_new(2, 5, FALSE);
		gtk_container_add(GTK_CONTAINER(nb_vbox), opt_table);
		gtk_container_border_width(GTK_CONTAINER(opt_table), 5);

			/* table attach a, b, c, d : (a, b) = horiz pos a to b, (c, d) = vert pos c to d */
		config_opt_swp = gtk_check_button_new_with_label("Save window position");
		gtk_table_attach_defaults(GTK_TABLE(opt_table), config_opt_swp, 0, 1, 0, 1);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_opt_swp), config.save_win_pos);

		config_opt_spp = gtk_check_button_new_with_label("Save playlist position");
		gtk_table_attach_defaults(GTK_TABLE(opt_table), config_opt_spp, 1, 2, 0, 1);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_opt_spp), config.save_plist_pos);

		config_opt_lpl = gtk_check_button_new_with_label("Lock playlist");
		gtk_table_attach_defaults(GTK_TABLE(opt_table), config_opt_lpl, 0, 1, 1, 2);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_opt_lpl), config.lock_plist);

		config_opt_cxs = gtk_check_button_new_with_label("Close XMMS window on startup");
		gtk_table_attach_defaults(GTK_TABLE(opt_table), config_opt_cxs, 1, 2, 1, 2);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_opt_cxs), config.close_main_startup);

		config_opt_oxc = gtk_check_button_new_with_label("Quit XMMS on exit");
		gtk_table_attach_defaults(GTK_TABLE(opt_table), config_opt_oxc, 0, 1, 2, 3);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_opt_oxc), config.quit_xmms_exit);

		opt = gtk_option_menu_new();
		menu = gtk_menu_new();
		item = gtk_menu_item_new_with_label("K-Jofol Playlist Editor");
		gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(cb_change_opt), GINT_TO_POINTER(0));
		gtk_menu_append(GTK_MENU(menu), item);
		item = gtk_menu_item_new_with_label("XMMS Playlist Editor");
		gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(cb_change_opt), GINT_TO_POINTER(1));
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_option_menu_set_menu(GTK_OPTION_MENU (opt), menu);
		config_pleditor = config.playlist_editor_type;
		gtk_option_menu_set_history(GTK_OPTION_MENU(opt), config_pleditor);
		gtk_table_attach_defaults(GTK_TABLE(opt_table), opt, 0, 2, 4, 5);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), nb_box, gtk_label_new("Options"));

			/*
			 * Resource selection page
			 */
		nb_box = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(nb_box), 5);

		res_frame = gtk_frame_new("Resource File");
		gtk_box_pack_start(GTK_BOX(nb_box), res_frame, FALSE, FALSE, 0);

		nb_vbox = gtk_vbox_new(FALSE, 5);
		gtk_container_set_border_width(GTK_CONTAINER(nb_vbox), 5);
		gtk_container_add(GTK_CONTAINER(res_frame), nb_vbox);

		res_clist = gtk_clist_new_with_titles(1, resource_titles);
		gtk_clist_column_titles_passive(GTK_CLIST(res_clist));
		gtk_clist_set_selection_mode(GTK_CLIST(res_clist), GTK_SELECTION_SINGLE);
		gtk_signal_connect(GTK_OBJECT(res_clist), "select_row", GTK_SIGNAL_FUNC(cb_change_res), NULL);
		gtk_widget_set_usize(res_clist, 250, 200);

		res_swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_container_add(GTK_CONTAINER(res_swin), res_clist);
		gtk_container_border_width(GTK_CONTAINER(res_swin), 5);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(res_swin), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
		gtk_box_pack_start(GTK_BOX(nb_vbox), res_swin, TRUE, TRUE, 0);

		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), nb_box, gtk_label_new("Resource"));

			/* OK/Cancel buttons */
		bbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
		gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
		gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

		ok = gtk_button_new_with_label("Ok");
		gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(cb_kj_configure_ok), NULL);
		GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
		gtk_widget_grab_default(ok);

		cancel = gtk_button_new_with_label("Cancel");
		gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(kj_configure_win));
		GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
      gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
		gtk_widget_show(cancel);

		gtk_widget_show_all(kj_configure_win);

		for(i = 0; i < g_list_length(res_list); i++)
			{
			entry = g_list_nth(res_list, i);
			gtk_clist_append(GTK_CLIST(res_clist), (gchar **) & ((res_node *)entry->data)->name);
			if(config.res_name && !strcmp(((res_node *)entry->data)->path, config.res_name))
				gtk_clist_select_row(GTK_CLIST(res_clist), i, 0);
			}
		}
}


/* ---------------------------------------------------------------------- */
void kj_about(void)
{
static gchar *res_str = NULL;
GtkWidget *button, *label, *res_label;
gint i, len;

	if(kj_about_win) return;
	kj_about_win = gtk_dialog_new();
	gtk_signal_connect(GTK_OBJECT(kj_about_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &kj_about_win);
	gtk_window_set_title(GTK_WINDOW(kj_about_win), "About K-Jofol Interface");
	gtk_window_set_position(GTK_WINDOW(kj_about_win), GTK_WIN_POS_MOUSE);
	gtk_container_border_width(GTK_CONTAINER(kj_about_win), 5);
	label = gtk_label_new("XMMS K-Jofol Interface 0.95\n\n \
Created by Tim Ferguson <timf@csse.monash.edu.au>.\n \
http://www.csse.monash.edu.au/~timf/\n\n \
Skin Information:\n \
");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(kj_about_win)->vbox), label, TRUE, TRUE, 0);

	if(res_str) g_free(res_str);
	for(i = 0, len = 0; i < res.about_str_num; i++)
		len += strlen(res.about_str[i]);
	res_str = g_malloc(len + 20);
	res_str[0] = '\0';
	for(i = 0; i < res.about_str_num; i++)
		{
		strcat(res_str, res.about_str[i]);
		strcat(res_str, "\n");
		}
	res_label = gtk_label_new(res_str);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(kj_about_win)->vbox), res_label, TRUE, TRUE, 0);

	button = gtk_button_new_with_label(" Close ");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(kj_about_win));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(kj_about_win)->action_area), button, FALSE, FALSE, 0);

	gtk_widget_show_all(kj_about_win);
	gtk_widget_grab_focus(button);
}
