/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "bbstabwidget.h"
#include "bbsview.h"
#include "libkita/signalcollection.h"

#include <klocale.h>

/*--------------------------------------------------------------*/


KitaBBSTabWidget::KitaBBSTabWidget( QWidget* parent, const char* name, WFlags fl )
        : KitaTabWidgetBase( parent, name, fl )
{
    KitaBBSView * view = new KitaBBSView( this );
    addTab( view, i18n( "board name" ) );
}


KitaBBSTabWidget::~KitaBBSTabWidget() {}


/* public slot */
void KitaBBSTabWidget::showBoardList()
{
    static_cast < KitaBBSView* > ( page( 0 ) ) ->showBoardList();
}

void KitaBBSTabWidget::updateBoardList()
{
    static_cast < KitaBBSView* > ( page( 0 ) ) ->updateBoardList();
}

/* public slot */
void KitaBBSTabWidget::setFont( const QFont& font )
{
    QTabWidget::setFont( font );
    static_cast < KitaBBSView* > ( page( 0 ) ) ->setFont( font );
}


void KitaBBSTabWidget::loadOpened()
{
    static_cast < KitaBBSView* > ( page( 0 ) ) ->loadOpened();
}

/* protected */ /* virtual */
void KitaBBSTabWidget::deleteWidget( QWidget* w ) {}


/*--------------------------------------------------------------*/


KitaBBSDock::KitaBBSDock( KDockManager* dockManager,
                              const char* name,
                              const QPixmap &pixmap,
                              QWidget* parent,
                              const QString& strCaption,
                              const QString& strTabPageLabel,
                              WFlags f )
        : KitaDockWidgetBase( dockManager, name, pixmap, parent, strCaption, strTabPageLabel, f ) {}


KitaBBSDock::~KitaBBSDock()
{
    if ( m_boardTab ) delete m_boardTab;
}


/* setup & create KitaBBSDock */ /* public */
KitaBBSTabWidget* KitaBBSDock::setup()
{
    /* create KitaNaviTabWidget */
    m_boardTab = new KitaBBSTabWidget( this, "Board" );
    setWidget( m_boardTab );

    Kita::SignalCollection* signalCollection = Kita::SignalCollection::getInstance();
    connect( signalCollection, SIGNAL( switchToBoard() ),
             SLOT( slotShowDock() ) );

    return m_boardTab;
}
