/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "threadlistviewitem.h"

using namespace Kita;

ThreadListViewItem::ThreadListViewItem( QListView* parent )
        : Kita::ListViewItem( parent )
{}

ThreadListViewItem::~ThreadListViewItem()
{}

/* public */ /* virtual */
int ThreadListViewItem::compare( QListViewItem* i, int col, bool ascending ) const
{
    switch ( col ) {
    case Col_ResNum:
    case Col_ReadNum:
    case Col_Unread:
        return i->key( col, ascending ).toInt() - key( col, ascending ).toInt();
    case Col_ID:
        return key( Col_IDOrder, ascending ).toInt() - i->key( Col_IDOrder, ascending ).toInt();
    case Col_Mark:
        return QString::localeAwareCompare( i->key( Col_MarkOrder, ascending ), key( Col_MarkOrder, ascending ) );
    case Col_Since:
        return QString::localeAwareCompare( i->key( col, ascending ), key( col, ascending ) );
    case Col_Speed:
        return static_cast<int>( i->key( col, ascending ).toDouble() * 1000 - key( col, ascending ).toDouble() * 1000 );
    default:
        return QString::localeAwareCompare( key( col, ascending ), i->key( col, ascending ) );
    }
}
