/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAIMGVIEW_H
#define KITAIMGVIEW_H

#include <kurl.h>
#include <qscrollview.h>

#include <sys/types.h>

class QImage;
class KActionCollection;
class KPopupMenu;
class KHTMLPart;
class QVBoxLayout;
class QPixmap;

/*----------------------------------------------------*/

class KitaImgView: public QScrollView
{
    Q_OBJECT

    KURL m_url;
    KURL m_datURL;
    KHTMLPart* m_htmlPart;
    QVBoxLayout* m_layout;
    KActionCollection* m_action;
    KPopupMenu* m_popup;
    QString m_message;
    QPixmap* m_pixmap;
    int m_size;
    int m_custom_wd;
    int m_custom_ht;
    int m_imgwd;
    int m_imght;
    bool m_dragScroll;
    int m_dragx;
    int m_dragy;

public:
    KitaImgView( const KURL& url, const KURL& datURL, KActionCollection* action, QWidget* parent, const char* name, WFlags fl );
    ~KitaImgView();

    const KURL url() const;
    const KURL datURL() const;
    void showMessage( QString message );

public slots:
    void slotShowImage();
    void slotFitToWin();
    void slotOriginalSize();
    void slotSetSize( int size );
    void slotCustomSize( int wd, int ht );
    void slotZoomIn();
    void slotZoomOut();

protected:
    virtual void resizeEvent( QResizeEvent * e );
    virtual void drawContents( QPainter * p, int clipx, int clipy, int clipw, int cliph );
    virtual void contentsMousePressEvent( QMouseEvent * e );
    virtual void contentsMouseMoveEvent( QMouseEvent * e );
    virtual void contentsMouseReleaseEvent( QMouseEvent * e );

private:
    bool resizeImage();
    void getImgSize( int& wd, int& ht );
    void myResizeContents();

    bool showImageWithKHTML();

private slots:
    void slotPopupMenu( const QString&, const QPoint& );

signals:
    void newImage( const QImage & ); /* to KviewViewer */
};

#endif
