/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "thread.h"

#include <qregexp.h>


using namespace Kita;

QDict<Thread>* Thread::m_threadDict = 0;

Thread::Thread( const KURL& datURL )
        : m_datURL( datURL ), m_threadName( 0 ) , m_resNum( 0 ), m_readNum( 0 ), m_viewPos( 0 ), m_isOpened( 0 )
{}

Thread::~Thread()
{}

const KURL& Thread::datURL() const
{
    return m_datURL;
}

/* public */
const QString& Thread::threadName() const
{
    return m_threadName;
}

/* public */
void Thread::setThreadName( QString threadName )
{
    /* remove space */
    QRegExp qrx( " +$" );
    threadName.replace( qrx, "" );

    /* unescape */
    threadName.replace( "&lt;", "<" ).replace( "&gt;", ">" ).replace( "&amp;", "&" );

    m_threadName = threadName;
}

/* public */
const int Thread::resNum() const
{
    return m_resNum;
}

/* public */
void Thread::setResNum( int num )
{
    m_resNum = num;
}

/* public */
const int Thread::readNum() const
{
    return m_readNum;
}

/* public */
void Thread::setReadNum( int num )
{
    m_readNum = num;
    if ( m_resNum < m_readNum ) setResNum( m_readNum );
}

/* public */
const int Thread::viewPos() const
{
    return m_viewPos;
}

/* public */
void Thread::setViewPos( int num )
{
    m_viewPos = num;
}


/* public */
bool Thread::isOpened() const
{
    return m_isOpened;
}

/* public */
void Thread::setIsOpened( bool isOpened )
{
    m_isOpened = isOpened;
}

/* public */
const QValueList< int >& Thread::markList() const
{
    return m_markList;
}

/* public */
void Thread::setMarkList( const QValueList< int >& markList )
{
    m_markList = markList;
}

/* public */
bool Thread::isMarked( int num )
{
    QValueList< int >::iterator it;
    for ( it = m_markList.begin(); it != m_markList.end(); ++it ) {
        if ( ( *it ) == num ) return TRUE;
    }

    return FALSE;
}

/* public */
bool Thread::setMark( int num, bool newStatus )
{
    bool status = isMarked( num );
    if ( status == newStatus ) return FALSE;

    if ( newStatus ) m_markList += num;
    else m_markList.remove( num );

    return TRUE;
}


/*--------------------------------------------*/

/* static functions */

Thread* Thread::getByURL( const KURL& datURL )
{
    if ( m_threadDict == 0 ) {
        m_threadDict = new QDict<Thread>();
    }

    Thread* thread = m_threadDict->find( datURL.prettyURL() );
    if ( thread ) return thread;

    Thread* newThread = new Thread( datURL );
    m_threadDict->insert( datURL.prettyURL(), newThread );

    return newThread;
}

/* static & public */
Thread* Thread::getByURLNew( const KURL& datURL )
{
    if ( m_threadDict == NULL ) return NULL;
    if ( datURL.isEmpty() ) return NULL;
    return m_threadDict->find( datURL.prettyURL() );
}

void Thread::replace( const QString& fromURL, const QString& toURL )
{
    if ( m_threadDict == NULL ) return ;
    QDictIterator<Kita::Thread> it( *m_threadDict );
    for ( ; it.current(); ++it ) {
        QString url = it.currentKey();
        Kita::Thread* thread = it.current();
        if ( url.find( fromURL ) == 0 ) {
            m_threadDict->remove( url );
            url = url.replace( 0, fromURL.length(), toURL );
            thread->m_datURL = url;
            m_threadDict->insert( url, thread );
            it.toFirst();
        }
    }
}
