/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "logwidget.h"
#include <kglobal.h>
#include <kiconloader.h>
#include <qdatetime.h>
#include <qtextstream.h>

LogWidget::LogWidget(QWidget *parent): QTable(parent), lastnum(0)
{
	setNumCols(1);	
	setShowGrid(false);
	verticalHeader()->hide();
	horizontalHeader()->hide();
	setTopMargin(0);
	setLeftMargin(0);
	setRowMovingEnabled(false);
	setColumnMovingEnabled(false);
	setColumnStretchable(0, true);
		
	status_fail = new QPixmap(KGlobal::iconLoader()->loadIcon("messagebox_critical", KIcon::Small));
	status_ok = new QPixmap(KGlobal::iconLoader()->loadIcon("button_ok", KIcon::Small));
	status_info = new QPixmap(KGlobal::iconLoader()->loadIcon("messagebox_info", KIcon::Small));

	//connect(this, SIGNAL(doubleClicked(int, int, int, const QPoint &)), this, SLOT(clicked(int)));
}

LogWidget::~LogWidget()
{
	delete status_ok;
	delete status_fail;
	delete status_info;
}

void LogWidget::appendOperation(const QString &txt)
{
	QTableItem *item = new QTableItem(this, QTableItem::Never, txt);
	setNumRows(lastnum + 1);
	setItem(lastnum, 0, item);
	++lastnum;
}

void LogWidget::appendOperation(const QString &txt, LogWidget::Status status)
{
	QTableItem *item = new QTableItem(this, QTableItem::Never, txt);
	setNumRows(lastnum + 1);
	setItem(lastnum, 0, item);
	++lastnum;
	setOperationStaus(status);
}

void LogWidget::setOperationStaus(LogWidget::Status status, const QString &descr)
{
	if (QTableItem *i = item(lastnum-1, 0))
	{
		QPixmap *icon;
		switch (status)
		{
			case STATUS_OK: icon = status_ok; break;
			case STATUS_FAIL: icon = status_fail; break;
			case STATUS_INFO: icon = status_info; break;
			default: icon = status_info; break;
		}
		i->setPixmap(*icon);
		if (descr != QString::null)
			i->setText(i->text() + " (" + descr + ")");
	}
}

void LogWidget::clicked(int row)
{
}

QString LogWidget::getLog() 
{
	QString s;
	QTextStream str(&s, IO_WriteOnly);
	writeLog(str);
	return s;
}

void LogWidget::writeLog(QTextStream &str) 
{
	for (int i=0; i<lastnum; i++)
		str << text(i, 0) << "\n";
}

bool LogWidget::isEmpty() const
{
	return lastnum == 0;
}

