/***************************************************************************
                          coorddialog.cpp  -  description
                             -------------------
    begin                : Die Feb 4 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "coorddialog.h"

// Qt includes
#include <qcheckbox.h>
#include <qfontmetrics.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvalidator.h>

// KDE includes
#include <kapplication.h>                                                                  
#include <klocale.h>

DSLineEdit::DSLineEdit( QWidget* parent, const char* name )
    : KLineEdit( parent, name )
{
}

void DSLineEdit::keyPressEvent( QKeyEvent* e )
{
    KLineEdit::keyPressEvent( e );
    emit changed();
}

void DSLineEdit::mousePressEvent( QMouseEvent* e )
{
    KLineEdit::mousePressEvent( e );
    emit changed();
}

bool CoordDialog::m_inversion = false;

CoordDialog::CoordDialog( const QString & file, QWidget *_parent, const char *name )
    : KDialogBase( KDialogBase::Plain, "KRename",
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, _parent, name, true, true ), m_file( file )
{
    QFrame* parent = plainPage();
    QVBoxLayout* layout = new QVBoxLayout( parent );

    filename = new DSLineEdit( parent );
    filename->setText( file );
    filename->setValidator( new QRegExpValidator( QRegExp( file ), this ) );
    
    preview = new QLabel( parent );

    checkInvert = new QCheckBox( i18n("&Invert selection"), plainPage() );
    checkInvert->setChecked( m_inversion );
    
    layout->addWidget( new QLabel( i18n("Please select the text you want to insert:"), plainPage() ) );
    layout->addWidget( filename );
    layout->addWidget( checkInvert );
    layout->addWidget( preview );

    updateCommand();
    connect( filename, SIGNAL( selectionChanged() ), this, SLOT( updateCommand() ) );
    connect( checkInvert, SIGNAL( clicked() ), this, SLOT( updateCommand() ) );
    connect( filename, SIGNAL( textChanged( const QString & ) ), this, SLOT( resetText() ) );
    connect( filename, SIGNAL( changed() ), this, SLOT( updateCommand() ) );

    show();
    
    QFontMetrics fm( filename->font() );
    int w = fm.width( file );
    if( w > width() )
        resize(
            ( w < KApplication::desktop()->width() - 40 ? w + 40 : KApplication::desktop()->width() ), height() );
}

CoordDialog::~CoordDialog()
{
}

void CoordDialog::updateCommand()
{
    int start = 0;
    int end = 0;
    m_command = "";    

    (void)filename->getSelection( &start, &end );

    if( !filename->text().isEmpty() ) {
       if( checkInvert->isChecked() && filename->hasSelectedText() ) {
            // inverted
            if( end ) {
                start++;
                end++;
                if( start > 1 )
                    m_command = QString("[$1;%1]").arg(start-1);

                if( end <= (signed int)filename->text().length() )
                    m_command.append( QString("[$%1-[length]]").arg(end) );
            } 
        } else if( checkInvert->isChecked() && !filename->hasSelectedText() ) {
            int p = filename->cursorPosition();
            m_command = QString("[$1;%1][$%2-[length]]").arg(p).arg(p+1);            
        } else if( !checkInvert->isChecked() && filename->hasSelectedText() ){
            if( end ) {
                start++;
                end++;
                if( end <= (signed int)filename->text().length() )
                    m_command = QString("[$%1;%2]").arg(start).arg(end-start);
                else
                    m_command = QString("[$%1-[length]]").arg(start);
            }
        } else if( !checkInvert->isChecked() && !filename->hasSelectedText() ) {
            int p = filename->cursorPosition();
            m_command = QString("[$%1-[length]]").arg( p );
        }

    }
    
    preview->setText( i18n("Preview: ") + m_command );
}

void CoordDialog::resetText()
{
    filename->setText( m_file );
    updateCommand();
}

QString CoordDialog::coords()
{
    m_inversion = checkInvert->isChecked();
    return m_command;
}
